/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TemplateParametersDialog
extends JDialog
implements ActionListener,
FocusListener {
    static final long serialVersionUID = 27L;
    public final float DEFAULT_LOSS_DEVIATION = 0.05f;
    public final float DEFAULT_REFLECTANCE_DEVIATION = 1.0f;
    public final float DEFAULT_LOSS_COEFFICIENT_DEVIATION = 0.002f;
    public final float DEFAULT_FULL_LOSS_DEVIATION = 1.0f;
    private MainClass mainClass;
    private JPanel dialogPane;
    private GridBagLayout gbLayout;
    private GridBagConstraints gbConstraints;
    private JLabel labelLossDeviation;
    private JTextField textFieldLossDeviation;
    private JLabel labelReflectanceDeviation;
    private JTextField textFieldReflectanceDeviation;
    private JLabel labelAttenuationDeviation;
    private JTextField textFieldAttenuationDeviation;
    private JLabel labelFullLossDeviation;
    private JTextField textFieldFullLossDeviation;
    private JButton okButton;
    private JButton cancelButton;

    TemplateParametersDialog(Frame owner, MainClass mClass) {
        super(owner);
        Component comp;
        this.mainClass = mClass;
        this.dialogPane = new JPanel();
        this.setContentPane(this.dialogPane);
        this.setModal(true);
        this.setTitle(this.mainClass.getResourceString("TemplateParameters"));
        this.setLocationRelativeTo(this.mainClass.otdrWindow);
        this.setResizable(false);
        this.gbLayout = new GridBagLayout();
        this.setLayout(this.gbLayout);
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 2;
        this.gbConstraints.anchor = 11;
        this.gbConstraints.weightx = 1.0;
        this.gbConstraints.weighty = 0.7;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 1;
        this.gbConstraints.insets = new Insets(2, 4, 2, 4);
        this.labelLossDeviation = new JLabel();
        this.labelLossDeviation.setText(this.mainClass.getResourceString("lossDeviationString"));
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.1;
        this.gbLayout.setConstraints(this.labelLossDeviation, this.gbConstraints);
        this.add(this.labelLossDeviation);
        this.textFieldLossDeviation = new JFormattedTextField();
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.9;
        this.gbLayout.setConstraints(this.textFieldLossDeviation, this.gbConstraints);
        this.textFieldLossDeviation.addFocusListener(this);
        this.textFieldLossDeviation.setHorizontalAlignment(4);
        this.add(this.textFieldLossDeviation);
        this.labelReflectanceDeviation = new JLabel();
        this.labelReflectanceDeviation.setText(this.mainClass.getResourceString("reflectanceDeviationString"));
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.1;
        this.gbLayout.setConstraints(this.labelReflectanceDeviation, this.gbConstraints);
        this.add(this.labelReflectanceDeviation);
        this.textFieldReflectanceDeviation = new JTextField();
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.9;
        this.gbLayout.setConstraints(this.textFieldReflectanceDeviation, this.gbConstraints);
        this.textFieldReflectanceDeviation.addFocusListener(this);
        this.textFieldReflectanceDeviation.setHorizontalAlignment(4);
        this.add(this.textFieldReflectanceDeviation);
        this.labelAttenuationDeviation = new JLabel();
        this.labelAttenuationDeviation.setText(this.mainClass.getResourceString("attenuationDeviationString"));
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.1;
        this.gbLayout.setConstraints(this.labelAttenuationDeviation, this.gbConstraints);
        this.add(this.labelAttenuationDeviation);
        this.textFieldAttenuationDeviation = new JTextField();
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.9;
        this.gbLayout.setConstraints(this.textFieldAttenuationDeviation, this.gbConstraints);
        this.textFieldAttenuationDeviation.addFocusListener(this);
        this.textFieldAttenuationDeviation.setHorizontalAlignment(4);
        this.add(this.textFieldAttenuationDeviation);
        this.labelFullLossDeviation = new JLabel();
        this.labelFullLossDeviation.setText(this.mainClass.getResourceString("fullLossDeviationString"));
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.1;
        this.gbLayout.setConstraints(this.labelFullLossDeviation, this.gbConstraints);
        this.add(this.labelFullLossDeviation);
        this.textFieldFullLossDeviation = new JTextField();
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.9;
        this.gbLayout.setConstraints(this.textFieldFullLossDeviation, this.gbConstraints);
        this.textFieldFullLossDeviation.addFocusListener(this);
        this.textFieldFullLossDeviation.setHorizontalAlignment(4);
        this.add(this.textFieldFullLossDeviation);
        this.okButton = new JButton();
        this.okButton.addActionListener(this);
        this.okButton.setText(this.mainClass.getResourceString("ok"));
        this.okButton.setName("okButton");
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 18;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.5;
        this.gbLayout.setConstraints(this.okButton, this.gbConstraints);
        this.add(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.cancelButton.setText(this.mainClass.getResourceString("cancel"));
        this.cancelButton.setName("cancelButton");
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 12;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridx = -1;
        this.gbConstraints.weightx = 0.5;
        this.gbLayout.setConstraints(this.cancelButton, this.gbConstraints);
        this.add(this.cancelButton);
        this.setMinimumSize(new Dimension(this.getFontMetrics(this.getFont()).stringWidth(this.getTitle()) + 50, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TemplateParametersDialog.this.cancelActions();
            }
        });
        this.pack();
        int minButtonWidth = 0;
        Component[] componentArray = this.dialogPane.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            comp = componentArray[n2];
            if (comp instanceof JButton) {
                minButtonWidth = Math.max(minButtonWidth, comp.getWidth());
            }
            ++n2;
        }
        componentArray = this.dialogPane.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            comp = componentArray[n2];
            if (comp instanceof JButton) {
                GridBagConstraints tmpConstraints = this.gbLayout.getConstraints(comp);
                tmpConstraints.ipadx = Math.max(0, minButtonWidth - comp.getWidth());
                this.gbLayout.setConstraints(comp, tmpConstraints);
            }
            ++n2;
        }
        this.pack();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        int referenceSorFileIndex = this.mainClass.getReferenceSorFileIndex();
        SorFile sorFile = this.mainClass.getSorFile(referenceSorFileIndex);
        if (sorFile == null) {
            return;
        }
        if (source instanceof JTextField) {
            JTextField tmpTextField = (JTextField)source;
            String oldSVal = "bad";
            String sVal = tmpTextField.getText();
            sVal = sVal.replace(",", ".");
            String format = "%.2f";
            if (this.textFieldLossDeviation == tmpTextField) {
                oldSVal = String.format(format, Float.valueOf((float)sorFile.svpReferenceParams.lossDeviation / 1000.0f));
            } else if (this.textFieldReflectanceDeviation == tmpTextField) {
                oldSVal = String.format(format, Float.valueOf((float)sorFile.svpReferenceParams.reflectanceDeviation / 1000.0f));
            } else if (this.textFieldAttenuationDeviation == tmpTextField) {
                format = "%.3f";
                oldSVal = String.format(format, Float.valueOf((float)sorFile.svpReferenceParams.lossCoefficientDeviation / 1000.0f));
            } else if (this.textFieldFullLossDeviation == tmpTextField) {
                oldSVal = String.format(format, Float.valueOf((float)sorFile.svpReferenceParams.fullLossDeviation / 1000.0f));
            }
            oldSVal = oldSVal.replace(",", ".");
            try {
                float val = Float.valueOf(sVal).floatValue();
                if (val < 0.0f) {
                    val = 0.0f;
                }
                if (val > 65.0f) {
                    val = 65.0f;
                }
                sVal = String.format(format, Float.valueOf(val));
                sVal = sVal.replace(",", ".");
            }
            catch (Exception exception) {
                System.out.printf("Exception: %s\n", exception.getMessage());
                sVal = oldSVal;
            }
            tmpTextField.setText(sVal);
        }
    }

    private void okActions() {
        int referenceSorFileIndex = this.mainClass.getReferenceSorFileIndex();
        SorFile sorFile = this.mainClass.getSorFile(referenceSorFileIndex);
        if (sorFile != null) {
            String tmpS = this.textFieldLossDeviation.getText().replace(',', '.');
            sorFile.svpReferenceParams.lossDeviation = Math.round(Float.valueOf(tmpS).floatValue() * 1000.0f);
            tmpS = this.textFieldReflectanceDeviation.getText().replace(',', '.');
            sorFile.svpReferenceParams.reflectanceDeviation = Math.round(Float.valueOf(tmpS).floatValue() * 1000.0f);
            tmpS = this.textFieldAttenuationDeviation.getText().replace(',', '.');
            sorFile.svpReferenceParams.lossCoefficientDeviation = Math.round(Float.valueOf(tmpS).floatValue() * 1000.0f);
            tmpS = this.textFieldFullLossDeviation.getText().replace(',', '.');
            sorFile.svpReferenceParams.fullLossDeviation = Math.round(Float.valueOf(tmpS).floatValue() * 1000.0f);
        }
        this.setVisible(false);
    }

    private void cancelActions() {
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            JButton button = (JButton)source;
            if ("okButton" == button.getName()) {
                this.okActions();
            } else if ("cancelButton" == button.getName()) {
                this.cancelActions();
            }
        }
    }

    public void updateView() {
        int referenceSorFileIndex = this.mainClass.getReferenceSorFileIndex();
        SorFile sorFile = this.mainClass.getSorFile(referenceSorFileIndex);
        if (sorFile == null) {
            return;
        }
        if (!sorFile.isSVPReferenceParamsPresent) {
            sorFile.isSVPReferenceParamsPresent = true;
            sorFile.svpReferenceParams.lossDeviation = Math.round(50.0f);
            sorFile.svpReferenceParams.reflectanceDeviation = Math.round(1000.0f);
            sorFile.svpReferenceParams.lossCoefficientDeviation = Math.round(2.0f);
            sorFile.svpReferenceParams.fullLossDeviation = Math.round(1000.0f);
        }
        String tmpS = String.format("%.2f", Float.valueOf((float)sorFile.svpReferenceParams.lossDeviation / 1000.0f));
        this.textFieldLossDeviation.setText(tmpS);
        tmpS = String.format("%.2f", Float.valueOf((float)sorFile.svpReferenceParams.reflectanceDeviation / 1000.0f));
        this.textFieldReflectanceDeviation.setText(tmpS);
        tmpS = String.format("%.3f", Float.valueOf((float)sorFile.svpReferenceParams.lossCoefficientDeviation / 1000.0f));
        this.textFieldAttenuationDeviation.setText(tmpS);
        tmpS = String.format("%.2f", Float.valueOf((float)sorFile.svpReferenceParams.fullLossDeviation / 1000.0f));
        this.textFieldFullLossDeviation.setText(tmpS);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.updateView();
        }
        super.setVisible(visible);
    }
}

