/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.print.PageFormat;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;

public class OtdrWindow
extends JPanel {
    public static final int RFG_BKGND_VIEW_OFFSET = 5;
    public static final int RFG_BKGND_SCALE_WIDTH = 45;
    public static final int RFG_BKGND_SCALE_HEIGHT = 20;
    static final long serialVersionUID = 1L;
    private RfgBackGroundPanel rfgBackGroundPanel;
    private MainClass mainClass;
    public OtdrEventsPanel otdrEventsPanel;

    public OtdrWindow(MainClass mC) {
        this.mainClass = mC;
        this.rfgBackGroundPanel = new RfgBackGroundPanel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int x = OtdrWindow.this.getX();
                int y = OtdrWindow.this.getY();
                int w = OtdrWindow.this.getWidth();
                int h = OtdrWindow.this.getHeight();
                int toolBarHeight = 50;
                int statusBarHeight = 25;
                int otdrControlPanelWidth = 150;
                int i = 0;
                while (i < OtdrWindow.this.getComponentCount()) {
                    Component component = OtdrWindow.this.getComponent(i);
                    if (component instanceof RfgBackGroundPanel) {
                        component.setBounds(x + otdrControlPanelWidth, y + toolBarHeight, w - otdrControlPanelWidth, h - (statusBarHeight + toolBarHeight));
                    } else if (component instanceof JToolBar) {
                        component.setBounds(x, y, w, toolBarHeight);
                    } else if (component instanceof MainClass.StatusBar) {
                        component.setBounds(x, y + h - statusBarHeight, w, statusBarHeight);
                    } else if (component instanceof OtdrControlPanel) {
                        component.setBounds(x, y + toolBarHeight, otdrControlPanelWidth, h - (statusBarHeight + toolBarHeight));
                    }
                    ++i;
                }
            }
        });
        this.setLayout(null);
        this.add((Component)this.rfgBackGroundPanel, "Center");
    }

    public MainClass getMainClass() {
        return this.mainClass;
    }

    public RfgBackGroundPanel getRfgBackGroundPanel() {
        return this.rfgBackGroundPanel;
    }

    class RfgBackGroundPanel
    extends JPanel {
        static final long serialVersionUID = 3L;
        public MyAdjustmentListener adjustmentListener;
        private RfgView rfgView;
        private JPanel scrollPanel;
        private JScrollBar verticalBar;
        private JScrollBar horizontalBar;

        RfgBackGroundPanel() {
            this.setBackground(RfgView.COLOR_BACK);
            this.setLayout(null);
            this.scrollPanel = new JPanel();
            this.verticalBar = new JScrollBar(1);
            this.horizontalBar = new JScrollBar(0);
            this.verticalBar.setName("verticalBar");
            this.horizontalBar.setName("horizontalBar");
            this.adjustmentListener = new MyAdjustmentListener();
            this.verticalBar.addAdjustmentListener(this.adjustmentListener);
            this.horizontalBar.addAdjustmentListener(this.adjustmentListener);
            this.rfgView = new RfgView(OtdrWindow.this.mainClass, this);
            this.add(this.scrollPanel);
            this.scrollPanel.setLayout(new BorderLayout());
            this.scrollPanel.add((Component)this.rfgView, "Center");
            this.scrollPanel.add((Component)this.verticalBar, "East");
            this.scrollPanel.add((Component)this.horizontalBar, "South");
            OtdrWindow.this.otdrEventsPanel = new OtdrEventsPanel(OtdrWindow.this.mainClass);
            this.scrollPanel.add((Component)OtdrWindow.this.otdrEventsPanel, "North");
            OtdrWindow.this.otdrEventsPanel.setVisible(false);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int x = RfgBackGroundPanel.this.getX();
                    int y = RfgBackGroundPanel.this.getY();
                    int w = RfgBackGroundPanel.this.getWidth();
                    int h = RfgBackGroundPanel.this.getHeight();
                    w = w - 5 - 45;
                    x = 45;
                    y = 0;
                    RfgBackGroundPanel.this.scrollPanel.setBounds(x, y, w, h -= 20);
                    RfgBackGroundPanel.this.validate();
                }
            });
        }

        public void reCreateOtdrEventsPanel() {
            this.scrollPanel.remove(OtdrWindow.this.otdrEventsPanel);
            boolean oldVisible = OtdrWindow.this.otdrEventsPanel.isVisible();
            OtdrWindow.this.otdrEventsPanel = new OtdrEventsPanel(OtdrWindow.this.mainClass);
            this.scrollPanel.add((Component)OtdrWindow.this.otdrEventsPanel, "North");
            OtdrWindow.this.otdrEventsPanel.setVisible(oldVisible);
        }

        public void drawScale_good0(Graphics g) {
            int y;
            SorFile sorFile = null;
            sorFile = OtdrWindow.this.mainClass.getSorFile(OtdrWindow.this.mainClass.getReferenceSorFileIndex());
            if (sorFile == null) {
                return;
            }
            if (sorFile.dataPts == null) {
                return;
            }
            if (sorFile.dataPts.scaledData == null) {
                return;
            }
            float width = this.getWidth();
            float height = this.getHeight();
            Image memImage = this.createImage((int)width, (int)height);
            Graphics2D memGraphics2 = (Graphics2D)memImage.getGraphics();
            memGraphics2.setColor(RfgView.COLOR_BACK);
            memGraphics2.fillRect(0, 0, 45, (int)height);
            memGraphics2.fillRect(0, (int)height - 20, (int)width, 20);
            Font fnt = new Font("Arial Cyr", 0, 16);
            memGraphics2.setFont(fnt);
            FontMetrics fm = memGraphics2.getFontMetrics();
            sorFile.recalcXYSteps(OtdrWindow.this.mainClass, this.rfgView.getWidth(), this.rfgView.getHeight(), sorFile);
            String tmpS = "";
            float topDb = (float)sorFile.yOffset / sorFile.getYStep();
            float bottomDb = (float)(sorFile.yOffset + this.rfgView.getHeight() - 1) / sorFile.getYStep();
            float dX = (bottomDb - topDb) / 10.0f;
            String format = dX < 0.01f ? "%06.3f" : "%05.2f";
            int x = 1;
            float dB = topDb;
            int i = 0;
            while ((float)i < 10.0f) {
                if (i == 0) {
                    tmpS = "dB";
                    memGraphics2.setColor(Color.yellow);
                } else {
                    tmpS = String.format(format, Float.valueOf(dB));
                    memGraphics2.setColor(Color.lightGray);
                }
                y = (int)((float)(this.scrollPanel.getY() + this.rfgView.getY()) + (float)i * ((float)this.rfgView.getHeight() / 10.0f) + (float)(fm.getHeight() / 2));
                if (y < fm.getHeight()) {
                    y = fm.getHeight();
                }
                if ((float)y >= height - 20.0f) {
                    y = (int)(height - 20.0f - 5.0f);
                }
                memGraphics2.drawString(tmpS, x, y);
                dB += dX;
                ++i;
            }
            float leftKm = (float)sorFile.recalcDistance(sorFile.indexOffset);
            float rightKm = (float)sorFile.recalcDistance(sorFile.indexOffset + (int)((float)(this.rfgView.getWidth() - 1) / sorFile.getXStep()));
            dX = (rightKm - leftKm) / 10.0f;
            format = dX < 0.01f ? "%.3f" : (dX < 0.1f ? "%.2f" : (dX < 1.0f ? "%.1f" : (dX < 10.0f ? "%.0f" : "%.0f")));
            y = this.getHeight() - 2;
            float km = leftKm;
            memGraphics2.setColor(Color.lightGray);
            i = 0;
            while (i <= 10) {
                tmpS = String.format(format, Float.valueOf(km));
                if (i == 0) {
                    tmpS = String.valueOf(tmpS) + " km";
                }
                if ((x = this.scrollPanel.getX() + this.rfgView.getX() + i * (this.rfgView.getWidth() / 10) - (int)fm.getStringBounds(tmpS, memGraphics2).getWidth() / 2) < 0) {
                    x = 5;
                }
                if (x + (int)fm.getStringBounds(tmpS, memGraphics2).getWidth() >= this.getWidth()) {
                    x = this.getWidth() - (int)fm.getStringBounds(tmpS, memGraphics2).getWidth() - 5;
                }
                if (i == 0) {
                    tmpS = String.format(format, Float.valueOf(km));
                }
                memGraphics2.drawString(tmpS, x, y);
                if (i == 0) {
                    x += (int)fm.getStringBounds(tmpS, memGraphics2).getWidth();
                    tmpS = " km";
                    memGraphics2.setColor(Color.yellow);
                    memGraphics2.drawString(tmpS, x, y);
                    memGraphics2.setColor(Color.lightGray);
                }
                km += dX;
                ++i;
            }
            g.drawImage(memImage, 0, 0, 45, (int)height, 0, 0, 45, (int)height, RfgView.COLOR_BACK, null);
            g.drawImage(memImage, 0, this.getHeight() - 20, this.getWidth(), this.getHeight(), 0, this.getHeight() - 20, this.getWidth(), this.getHeight(), RfgView.COLOR_BACK, null);
        }

        public void drawScale(Graphics g, PageFormat pf, Rectangle rfgViewRect) {
            int y;
            int rfgViewY;
            int rfgViewX;
            int rfgViewH;
            int rfgViewW;
            int y0;
            int x0;
            float height;
            float width;
            SorFile sorFile = null;
            sorFile = OtdrWindow.this.mainClass.getSorFile(OtdrWindow.this.mainClass.getReferenceSorFileIndex());
            if (sorFile == null) {
                return;
            }
            if (sorFile.dataPts == null) {
                return;
            }
            if (sorFile.dataPts.scaledData == null) {
                return;
            }
            if (pf != null) {
                Rectangle rect = g.getClipBounds();
                width = rect.width;
                height = rect.height;
                x0 = rect.x;
                y0 = rect.y;
            } else {
                width = this.getWidth();
                height = this.getHeight();
                x0 = 0;
                y0 = 0;
            }
            Image memImage = this.createImage((int)width, (int)height);
            Graphics2D memGraphics2 = (Graphics2D)memImage.getGraphics();
            if (pf == null) {
                memGraphics2.setColor(RfgView.COLOR_BACK);
            } else {
                memGraphics2.setColor(Color.WHITE);
            }
            memGraphics2.fillRect(0, 0, 45, (int)height);
            memGraphics2.fillRect(0, (int)height - 20, (int)width, 20);
            int fontSize = pf == null ? 16 : 10;
            Font fnt = new Font("Arial Cyr", 0, fontSize);
            memGraphics2.setFont(fnt);
            FontMetrics fm = memGraphics2.getFontMetrics();
            if (rfgViewRect == null) {
                rfgViewW = this.rfgView.getWidth();
                rfgViewH = this.rfgView.getHeight();
                rfgViewX = this.scrollPanel.getX() + this.rfgView.getX();
                rfgViewY = this.scrollPanel.getY() + this.rfgView.getY();
            } else {
                rfgViewW = rfgViewRect.width;
                rfgViewH = rfgViewRect.height;
                rfgViewX = 45;
                rfgViewY = 0;
            }
            sorFile.recalcXYSteps(OtdrWindow.this.mainClass, rfgViewW, rfgViewH, sorFile);
            String tmpS = "";
            float localYOffset = (float)sorFile.yOffset * (float)rfgViewH / (float)this.rfgView.getHeight();
            float topDb = localYOffset / sorFile.getYStep() + sorFile.dataPts.minData;
            float bottomDb = (localYOffset + (float)rfgViewH - 1.0f) / sorFile.getYStep() + sorFile.dataPts.minData;
            float dX = (bottomDb - topDb) / 10.0f;
            String format = dX < 0.01f ? "%06.3f" : "%05.2f";
            int x = 1;
            float dB = topDb;
            int i = 0;
            while ((float)i < 10.0f) {
                if (i == 0) {
                    tmpS = OtdrWindow.this.mainClass.getResourceString("dB");
                    if (pf == null) {
                        memGraphics2.setColor(Color.yellow);
                    } else {
                        memGraphics2.setColor(Color.BLACK);
                    }
                } else {
                    tmpS = String.format(format, Float.valueOf(dB));
                    memGraphics2.setColor(Color.lightGray);
                }
                y = (int)((float)rfgViewY + (float)i * ((float)rfgViewH / 10.0f) + (float)(fm.getHeight() / 2));
                if (y < fm.getHeight()) {
                    y = fm.getHeight();
                }
                if ((float)y >= height - 20.0f) {
                    y = (int)(height - 20.0f - 5.0f);
                }
                memGraphics2.drawString(tmpS, x, y);
                dB += dX;
                ++i;
            }
            float leftKm = (float)sorFile.recalcDistance(sorFile.indexOffset);
            float rightKm = (float)sorFile.recalcDistance(sorFile.indexOffset + (int)((float)(rfgViewW - 1) / sorFile.getXStep()));
            dX = (rightKm - leftKm) / 10.0f;
            format = dX < 0.01f ? "%.3f" : (dX < 0.1f ? "%.2f" : (dX < 1.0f ? "%.1f" : (dX < 10.0f ? "%.0f" : "%.0f")));
            y = (int)height - 2;
            float km = leftKm;
            memGraphics2.setColor(Color.lightGray);
            i = 0;
            while (i <= 10) {
                tmpS = String.format(format, Float.valueOf(km));
                if (i == 0) {
                    tmpS = String.valueOf(tmpS) + " " + OtdrWindow.this.mainClass.getResourceString("km");
                }
                if ((x = rfgViewX + i * (rfgViewW / 10) - (int)fm.getStringBounds(tmpS, memGraphics2).getWidth() / 2) < 0) {
                    x = 5;
                }
                if (x + (int)fm.getStringBounds(tmpS, memGraphics2).getWidth() >= (int)width) {
                    x = (int)width - (int)fm.getStringBounds(tmpS, memGraphics2).getWidth() - 5;
                }
                if (i == 0) {
                    tmpS = String.format(format, Float.valueOf(km));
                }
                memGraphics2.drawString(tmpS, x, y);
                if (i == 0) {
                    x += (int)fm.getStringBounds(tmpS, memGraphics2).getWidth();
                    tmpS = " " + OtdrWindow.this.mainClass.getResourceString("km");
                    if (pf == null) {
                        memGraphics2.setColor(Color.yellow);
                    } else {
                        memGraphics2.setColor(Color.BLACK);
                    }
                    memGraphics2.drawString(tmpS, x, y);
                    memGraphics2.setColor(Color.lightGray);
                }
                km += dX;
                ++i;
            }
            g.drawImage(memImage, x0 + 0, y0 + 0, x0 + 45, y0 + (int)height, 0, 0, 45, (int)height, RfgView.COLOR_BACK, null);
            g.drawImage(memImage, x0 + 0, y0 + (int)height - 20, x0 + (int)width, y0 + (int)height, 0, (int)height - 20, (int)width, (int)height, RfgView.COLOR_BACK, null);
        }

        public RfgView getRfgView() {
            return this.rfgView;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.drawScale(g, null, null);
        }

        public JScrollBar getHorizontalBar() {
            return this.horizontalBar;
        }

        public JScrollBar getVerticalBar() {
            return this.verticalBar;
        }

        public class MyAdjustmentListener
        implements AdjustmentListener {
            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                SorFile sorFile = RfgBackGroundPanel.this.rfgView.getSorFile(OtdrWindow.this.mainClass.getReferenceSorFileIndex());
                if (sorFile == null) {
                    return;
                }
                if (sorFile.dataPts == null) {
                    return;
                }
                if (!sorFile.isDataPtsPresent) {
                    return;
                }
                Object source = e.getSource();
                if (source instanceof JScrollBar) {
                    JScrollBar bar = (JScrollBar)source;
                    if (bar.getOrientation() == 0) {
                        sorFile.indexOffset = Math.round((float)bar.getValue() / Float.valueOf(((OtdrWindow)((RfgBackGroundPanel)RfgBackGroundPanel.this).OtdrWindow.this).mainClass.xScale).floatValue());
                        if (sorFile.indexOffset < sorFile.positiveDistanceIndex) {
                            sorFile.indexOffset = sorFile.positiveDistanceIndex;
                        }
                        RfgBackGroundPanel.this.rfgView.invalidateView();
                        RfgBackGroundPanel.this.rfgView.autoSearchRfg();
                        RfgBackGroundPanel.this.updateUI();
                    } else if (1 == bar.getOrientation()) {
                        sorFile.yOffset = bar.getValue();
                        RfgBackGroundPanel.this.rfgView.invalidateView();
                        RfgBackGroundPanel.this.rfgView.autoSearchRfg();
                        RfgBackGroundPanel.this.updateUI();
                    } else {
                        System.out.println("NO_ORIENTATION!!!");
                    }
                }
            }
        }
    }
}

