/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;

public class OTDRFindDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = 22L;
    private MainClass mainClass;
    private GridBagLayout gbLayout;
    private GridBagConstraints gbConstraints;
    private JLabel label;
    private JLabel iconLabel;
    private ImageIcon icon;
    private JButton button;
    private Timer timer;
    private int iconIndex = 1;
    private int iconIndexDelta = 1;
    private static final int maxIconIndex = 5;
    public static final int BUTTON_STATE_CANCEL = 0;
    public static final int BUTTON_STATE_OK = 1;
    private static final String[] buttonStrings = new String[]{"cancel", "ok"};
    private int buttonStateIndex;

    public OTDRFindDialog(MainClass mClass) {
        super(mClass.mainFrame);
        this.mainClass = mClass;
        this.setTitle(this.mainClass.getResourceString("OTDRFindDialogCaption"));
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(this.mainClass.otdrWindow);
        this.gbLayout = new GridBagLayout();
        this.setLayout(this.gbLayout);
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.gridx = -1;
        this.gbConstraints.gridy = -1;
        this.gbConstraints.gridwidth = 0;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 11;
        this.gbConstraints.weightx = 1.0;
        this.gbConstraints.weighty = 1.0;
        this.gbConstraints.ipadx = 0;
        this.gbConstraints.ipady = 0;
        this.gbConstraints.insets = new Insets(10, 10, 10, 10);
        this.label = new JLabel();
        this.label.setText(this.mainClass.getResourceString("CONNECTING_TO_OTDR_MODULE_PLEASE_WAIT"));
        this.gbLayout.setConstraints(this.label, this.gbConstraints);
        this.add(this.label);
        this.icon = this.mainClass.loadImageIcon("resources/connect1.gif");
        if (this.icon != null) {
            this.iconLabel = new JLabel(this.icon);
            this.gbLayout.setConstraints(this.iconLabel, this.gbConstraints);
            this.add(this.iconLabel);
        }
        this.button = new JButton();
        this.button.addActionListener(this);
        this.gbLayout.setConstraints(this.button, this.gbConstraints);
        this.add(this.button);
        this.timer = new Timer(100, this);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.button) {
            if (this.buttonStateIndex == 0) {
                this.mainClass.getTL1RTUClient().disconnect();
            }
            this.setVisible(false);
        } else if (source == this.timer) {
            String iconString = String.format("resources/connect%d.gif", this.iconIndex);
            this.iconIndex += this.iconIndexDelta;
            if (5 < this.iconIndex || 1 > this.iconIndex) {
                this.iconIndexDelta = -this.iconIndexDelta;
                this.iconIndex += this.iconIndexDelta;
            }
            this.setIcon(this.mainClass.loadImageIcon(iconString));
        }
    }

    public void setButtonStateIndex(int to) {
        this.buttonStateIndex = to;
        this.button.setText(this.mainClass.getResourceString(buttonStrings[this.buttonStateIndex]));
    }

    public void setLabelText(String to) {
        this.label.setText(to);
    }

    public void setIcon(ImageIcon to) {
        this.icon = to;
        if (this.iconLabel != null) {
            this.iconLabel.setIcon(this.icon);
        }
    }

    public String getLabelText() {
        return this.label.getText();
    }

    public int getButtonStateIndex() {
        return this.buttonStateIndex;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setButtonStateIndex(0);
            this.updateView();
        } else {
            this.stopTimer();
        }
        this.button.requestFocus();
        super.setVisible(b);
    }

    public void updateView() {
        this.pack();
    }

    public void startTimer() {
        this.timer.start();
    }

    public void stopTimer() {
        this.timer.stop();
    }
}

