/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class MainClass {
    static final boolean DEBUG = false;
    public JFrame mainFrame;
    public OtdrWindow otdrWindow;
    public OtdrControlPanel otdrControlPanel;
    private MyActionListener actionListener;
    private JMenu menuFile;
    private JMenu menuMeasuring;
    private JMenu menuMode;
    private JMenu menuEvents;
    private JMenu menuTools;
    private JMenu menuLookAndFeel;
    private JMenu menuHelp;
    private JMenuItem menuItemCloseFile;
    private JMenuItem menuItemCloseAllFiles;
    private JMenuItem menuItemSave;
    private JMenuItem menuItemSaveAS;
    private JMenuItem menuItemPrint;
    private JMenuItem menuItemInformation;
    private JMenuItem menuItemTemplateParameters;
    private JMenuItem[] menuItemsMeasuring;
    private JMenuItem menuItemFixEvent;
    private JCheckBoxMenuItem menuItemEventsTable;
    private JCheckBoxMenuItem menuItemEventsTwoWay;
    public JCheckBoxMenuItem menuItemAutosearch;
    public JCheckBoxMenuItem menuItemFixCursors;
    private JButton toolButtonOpen;
    private JButton toolButtonSave;
    private JButton toolButtonInformation;
    private JButton toolButtonConnectInstrument;
    private JButton toolButtonDisconnectInstrument;
    private JButton toolButtonStartMeasureAver;
    private JButton toolButtonStartMeasureLive;
    private JButton toolButtonStopMeasure;
    private JButton toolButtonMeasureParameters;
    private JButton toolButtonZoomOff;
    private JToggleButton toolButtonZoomMode;
    private JButton toolButtonZoomInX;
    private JButton toolButtonZoomOutX;
    private JButton toolButtonZoomInY;
    private JButton toolButtonZoomOutY;
    private JToggleButton toolButtonMode2P;
    private JToggleButton toolButtonModeLSALine;
    private JToggleButton toolButtonModeLSA;
    private JToggleButton toolButtonModeReflectance;
    private JToggleButton toolButtonModeORL;
    private JButton toolButtonModeRI;
    private JButton toolButtonFixEvent;
    private JButton toolButtonDeleteEvent;
    private JToggleButton toolButtonEventsTable;
    private JButton toolButtonDoAuto;
    private JButton toolButtonEventsParameters;
    private JToggleButton toolButtonEventsTwoWay;
    private JRadioButtonMenuItem[] measureModeMenuItems;
    private JRadioButtonMenuItem[] lafMenuItems;
    private File currentDirectory;
    private FileFilter sorFilter;
    public JComponent statusBar;
    public ImageIcon imageFE;
    public ImageIcon imageGain;
    public ImageIcon imageNR;
    public ImageIcon imageR;
    public JToolBar toolBar;
    private static final String sorFilesPathFile = "sorFilesPath.ser";
    private PrinterJob pj;
    private PageFormat pf;
    public static final String[] menuFileStrings;
    public static final String[] menuFileToolTipStrings;
    public static final int MENU_FILE_OPEN = 1;
    public static final int MENU_FILE_CLOSE_FILE = 2;
    public static final int MENU_FILE_CLOSE_ALL_FILES = 3;
    public static final int MENU_FILE_SAVE = 5;
    public static final int MENU_FILE_SAVE_AS = 6;
    public static final int MENU_FILE_PAGE_SETUP = 8;
    public static final int MENU_FILE_PRINT = 9;
    public static final int MENU_FILE_INFORMATION = 11;
    public static final int MENU_FILE_TEMPLATE_PARAMETERS = 12;
    public static final int MENU_FILE_CLOSE = 14;
    public static final String[] menuMeasuringStrings;
    public static final String[] menuMeasuringToolTipStrings;
    public static final int MENU_MEASURING_CONNECT = 1;
    public static final int MENU_MEASURING_DISCONNECT = 2;
    public static final int MENU_MEASURING_START_AVER = 4;
    public static final int MENU_MEASURING_START_LIVE = 5;
    public static final int MENU_MEASURING_STOP = 6;
    public static final int MENU_MEASURING_PARAMETERS = 8;
    public static final String[] menuModeStrings;
    public static final String[] menuModeToolTipStrings;
    public static final int MENU_MODE_2P = 0;
    public static final int MENU_MODE_LSA_LINE = 1;
    public static final int MENU_MODE_LSA = 2;
    public static final int MENU_MODE_REFLECTANCE = 3;
    public static final int MENU_MODE_ORL = 4;
    public static final String[] menuEventsStrings;
    public static final String[] menuEventsToolTipStrings;
    public static final int MENU_EVENTS_FIX = 1;
    public static final int MENU_EVENTS_DELETE = 2;
    public static final int MENU_EVENTS_TABLE = 3;
    public static final int MENU_EVENTS_DO_AUTO = 4;
    public static final int MENU_EVENTS_PARAMETERS = 5;
    public static final int MENU_EVENTS_TWO_WAY = 7;
    public static final MeasureMode[] menuModeItems;
    public static final String[] menuToolsStrings;
    public static final int MENU_TOOLS_AUTOSEARCH = 1;
    public static final int MENU_TOOLS_FIX_CURSORS = 2;
    public static final String[] menuHelpStrings;
    public static final int MENU_HELP_SHOW_HELP = 1;
    public static final int MENU_HELP_SHOW_ABOUT = 2;
    private boolean[] toolBarElementState;
    private boolean[] menuBarElementState;
    private static final int STATUS_WL_INDEX = 0;
    private static final int STATUS_N_INDEX = 1;
    private static final int STATUS_LMAX_INDEX = 2;
    private static final int STATUS_TP_INDEX = 3;
    private static final int STATUS_NAV_INDEX = 4;
    private static final int STATUS_L1_INDEX = 5;
    private static final int STATUS_L2_INDEX = 6;
    private static final int STATUS_DL_INDEX = 7;
    public static final String[] statusBarItems;
    public UIManager.LookAndFeelInfo[] lookAndFeelInfos;
    public static final String FONT_NAME = "Arial Cyr";
    public static final int FONT_SIZE = 16;
    public static final int PRINT_HEADER1_FONT_SIZE = 16;
    public static final int PRINT_HEADER2_FONT_SIZE = 12;
    public static final int PRINT_FONT_SIZE = 10;
    public static final int PRINT_SHAPE_FONT_SIZE = 8;
    public static final int PRINT_COLONTILE_FONT_SIZE = 6;
    public static final int PRINT_EVENTS_FONT_SIZE = 6;
    private static ResourceBundle resources;
    private MeasureMode measureMode;
    public static final int MAX_SOR_FILE_COUNT = 10;
    private AnalisysParametersDialog analisysParametersDialog;
    private RfgInformationDialog rfgInformationDialog;
    private AboutDialog aboutDialog;
    private SorFile[] sorFile;
    private SorFile.KeyEvents twoWayKeyEvents;
    private int currentSorFileIndex = 0;
    private TL1RTUClient client;
    private OTDRModuleParameters otdrModuleParameters;
    private OTDRParametersDialog otdrParametersDialog;
    private JEditorPane html;
    private JFrame hlpFrame;
    private JScrollPane hlpScroller;
    public static final int SCALE_NUMBER = 9;
    public String[] scaleList;
    public float maxXYScale;
    public String xScale = "1";
    public String yScale = "1";

    static {
        try {
            resources = ResourceBundle.getBundle("resources.o", Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            System.err.println("resources/o.properties not found");
            System.exit(1);
        }
        String[] stringArray = new String[16];
        stringArray[0] = "menuFile";
        stringArray[1] = "menuFileOpen";
        stringArray[2] = "menuFileCloseFile";
        stringArray[3] = "menuFileCloseAllFiles";
        stringArray[4] = "-";
        stringArray[5] = "menuFileSave";
        stringArray[6] = "menuFileSaveAs";
        stringArray[7] = "-";
        stringArray[8] = "menuFilePageSetup";
        stringArray[9] = "menuFilePrint";
        stringArray[10] = "-";
        stringArray[11] = "menuFileInformation";
        stringArray[12] = "menuFileTemplateParameters";
        stringArray[13] = "-";
        stringArray[14] = "menuFileClose";
        menuFileStrings = stringArray;
        String[] stringArray2 = new String[16];
        stringArray2[0] = "menuFileToolTip";
        stringArray2[1] = "menuFileOpenToolTip";
        stringArray2[2] = "menuFileCloseFileToolTip";
        stringArray2[3] = "menuFileCloseAllFilesToolTip";
        stringArray2[4] = "-";
        stringArray2[5] = "menuFileSaveToolTip";
        stringArray2[6] = "menuFileSaveAsToolTip";
        stringArray2[7] = "-";
        stringArray2[8] = "menuFilePageSetupToolTip";
        stringArray2[9] = "menuFilePrintToolTip";
        stringArray2[10] = "-";
        stringArray2[11] = "menuFileInformationToolTip";
        stringArray2[12] = "menuFileTemplateParametersToolTip";
        stringArray2[13] = "-";
        stringArray2[14] = "menuFileCloseToolTip";
        menuFileToolTipStrings = stringArray2;
        String[] stringArray3 = new String[10];
        stringArray3[0] = "menuMeasuring";
        stringArray3[1] = "menuMeasuringConnect";
        stringArray3[2] = "menuMeasuringDisconnect";
        stringArray3[3] = "-";
        stringArray3[4] = "menuMeasuringStartAver";
        stringArray3[5] = "menuMeasuringStartLive";
        stringArray3[6] = "menuMeasuringStop";
        stringArray3[7] = "-";
        stringArray3[8] = "menuMeasuringParameters";
        menuMeasuringStrings = stringArray3;
        String[] stringArray4 = new String[10];
        stringArray4[0] = "menuMeasuringToolTip";
        stringArray4[1] = "menuMeasuringConnectToolTip";
        stringArray4[2] = "menuMeasuringDisconnectToolTip";
        stringArray4[3] = "-";
        stringArray4[4] = "menuMeasuringStartAverToolTip";
        stringArray4[5] = "menuMeasuringStartLiveToolTip";
        stringArray4[6] = "menuMeasuringStopToolTip";
        stringArray4[7] = "-";
        stringArray4[8] = "menuMeasuringParametersToolTip";
        menuMeasuringToolTipStrings = stringArray4;
        menuModeStrings = new String[]{"menuMode2P", "menuModeLSALine", "menuModeLSA", "menuModeReflectance", "menuModeORL"};
        menuModeToolTipStrings = new String[]{"menuMode2PToolTip", "menuModeLSALineToolTip", "menuModeLSAToolTip", "menuModeReflectanceToolTip", "menuModeORLToolTip"};
        menuEventsStrings = new String[]{"menuEvents", "menuEventsFix", "menuEventsDelete", "menuEventsTable", "menuEventsDoAuto", "menuEventsParameters", "-", "menuEventsTwoWay"};
        menuEventsToolTipStrings = new String[]{"menuEventsToolTip", "menuEventsFixToolTip", "menuEventsDeleteToolTip", "menuEventsTableToolTip", "menuEventsDoAutoToolTip", "menuEventsParametersToolTip", "-", "menuEventsTwoWayToolTip"};
        menuModeItems = new MeasureMode[]{MeasureMode.MEASURE_MODE_2P_LOSS, MeasureMode.MEASURE_MODE_APPROX_LOSS, MeasureMode.MEASURE_MODE_LSA_LOSS, MeasureMode.MEASURE_MODE_REFLECTANCE, MeasureMode.MEASURE_MODE_ORL};
        String[] stringArray5 = new String[4];
        stringArray5[0] = "menuTools";
        stringArray5[1] = "menuToolsAutosearch";
        stringArray5[2] = "menuToolsFixCursors";
        menuToolsStrings = stringArray5;
        menuHelpStrings = new String[]{"Help", "ShowHelp", "ShowAppAbout"};
        String[] stringArray6 = new String[9];
        stringArray6[0] = "waveLength";
        stringArray6[1] = "n";
        stringArray6[2] = "Lmax";
        stringArray6[3] = "Tp";
        stringArray6[4] = "Nav";
        stringArray6[5] = "L1";
        stringArray6[6] = "L2";
        stringArray6[7] = "dL";
        statusBarItems = stringArray6;
    }

    public static boolean isFloatNormal(float v) {
        return !Float.isInfinite(v) && !Float.isNaN(v);
    }

    public static PrintStream QDEBUG(String format, Object ... args) {
        return null;
    }

    public static PrintStream QDEBUG(boolean condition, String format, Object ... args) {
        return null;
    }

    public HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)MainClass.this.html.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                    } else {
                        try {
                            MainClass.this.html.setPage(e.getURL());
                        }
                        catch (IOException ioe) {
                            System.out.println("IOE: " + ioe);
                        }
                    }
                }
            }
        };
    }

    public void enableRFGControls(boolean enable) {
        this.menuMode.setEnabled(enable);
        this.menuEvents.setEnabled(enable);
        this.menuTools.setEnabled(enable);
        this.menuItemCloseFile.setEnabled(enable);
        this.menuItemCloseAllFiles.setEnabled(enable);
        this.menuItemSave.setEnabled(enable);
        this.toolButtonSave.setEnabled(enable);
        this.menuItemSaveAS.setEnabled(enable);
        this.menuItemPrint.setEnabled(enable);
        this.menuItemInformation.setEnabled(enable);
        this.menuItemTemplateParameters.setEnabled(enable);
        this.toolButtonInformation.setEnabled(enable);
        this.toolButtonMode2P.setEnabled(enable);
        this.toolButtonModeLSALine.setEnabled(enable);
        this.toolButtonModeLSA.setEnabled(enable);
        this.toolButtonModeReflectance.setEnabled(enable);
        this.toolButtonModeORL.setEnabled(enable);
        this.toolButtonModeRI.setEnabled(enable);
        this.toolButtonFixEvent.setEnabled(enable);
        this.toolButtonDeleteEvent.setEnabled(enable);
        this.toolButtonEventsTable.setEnabled(enable);
        this.toolButtonDoAuto.setEnabled(enable);
        this.toolButtonEventsParameters.setEnabled(enable);
        this.updateTwoWayCheckMenuItem();
    }

    public void updateAll() {
        int referenceSorFileIndex = this.getReferenceSorFileIndex();
        this.otdrWindow.getRfgBackGroundPanel().getRfgView().invalidateView();
        this.otdrWindow.updateUI();
        this.updateZoomControls();
        this.mainFrame.setTitle(String.valueOf(this.getResourceString("titleString")) + " - " + this.sorFile[this.currentSorFileIndex].getFileName());
        this.setMeasureMode(MeasureMode.MEASURE_MODE_2P_LOSS);
        this.updateStatusBar();
        this.updateOtdrControlPanel();
        this.updateScrolls();
        this.otdrControlPanel.getRfgMap().updateUI();
        this.otdrControlPanel.updateRfgList();
        this.otdrWindow.otdrEventsPanel.resetButtonMove();
        this.otdrWindow.otdrEventsPanel.setCurrentEventIndex(0);
        this.otdrWindow.otdrEventsPanel.updateView();
        boolean enable = false;
        if (referenceSorFileIndex >= 0) {
            enable = this.sorFile[referenceSorFileIndex].isDataPtsPresent;
            enable |= this.sorFile[referenceSorFileIndex].isKeyEventsPresent;
        }
        this.enableRFGControls(enable);
        boolean enableClose = this.sorFile[this.currentSorFileIndex].isDataPtsPresent;
        this.menuItemCloseFile.setEnabled(enableClose |= this.sorFile[this.currentSorFileIndex].isKeyEventsPresent);
        boolean enableCloseAll = false;
        int i = 0;
        while (i < this.sorFile.length) {
            enableCloseAll |= this.sorFile[i].isKeyEventsPresent;
            if (enableCloseAll |= this.sorFile[i].isDataPtsPresent) break;
            ++i;
        }
        this.menuItemCloseAllFiles.setEnabled(enableCloseAll);
        this.updateTwoWayCheckMenuItem();
    }

    public void updateTwoWayCheckMenuItem() {
        int goodCnt = 0;
        boolean oldCheck = this.isTwoWayChecked();
        int i = 0;
        while (i < this.sorFile.length) {
            if (this.otdrControlPanel.isRfgChecked(i)) {
                ++goodCnt;
            }
            ++i;
        }
        this.menuItemEventsTwoWay.setEnabled(2 == goodCnt);
        this.toolButtonEventsTwoWay.setEnabled(this.menuItemEventsTwoWay.isEnabled());
        if (!this.menuItemEventsTwoWay.isEnabled()) {
            this.menuItemEventsTwoWay.setSelected(false);
            this.toolButtonEventsTwoWay.setSelected(false);
        }
        if (oldCheck != this.isTwoWayChecked()) {
            this.menuEventsTwoWayChanged();
        }
    }

    public void setTwoWayCurrentSorFileIndex(int to) {
        if (to != this.currentSorFileIndex) {
            this.currentSorFileIndex = to;
            if (this.sorFile[to].isDataPtsPresent && this.sorFile[to].isKeyEventsPresent) {
                this.menuEventsTwoWayChanged();
            }
        }
    }

    public void menuEventsTwoWayChanged() {
        RfgView rfgView = this.otdrWindow.getRfgBackGroundPanel().getRfgView();
        if (this.isTwoWayChecked()) {
            float time;
            int referenceSorFileIndex = this.getReferenceSorFileIndex();
            SorFile sFile = null;
            if (referenceSorFileIndex >= 0 && this.sorFile.length > referenceSorFileIndex) {
                sFile = this.sorFile[referenceSorFileIndex];
            }
            if (sFile == null) {
                JOptionPane.showMessageDialog(this.mainFrame, this.getResourceString("ERR_CANT_FIND_REF_SOR_FILE"), this.getResourceString("titleString"), 0);
                this.setTwoWay(false);
                return;
            }
            SorFile mFile = null;
            int i = 0;
            while (i < this.sorFile.length) {
                if (this.otdrControlPanel.isRfgChecked(i) && referenceSorFileIndex != i) {
                    mFile = this.sorFile[i];
                    break;
                }
                ++i;
            }
            if (mFile == null) {
                JOptionPane.showMessageDialog(this.mainFrame, this.getResourceString("ERR_CANT_FIND_MEM_FILE"), this.getResourceString("titleString"), 0);
                this.setTwoWay(false);
                return;
            }
            boolean canShowReverse = sFile != null && sFile.isKeyEventsPresent;
            int endDataIndex = 0;
            int endOfFiberTime = 0;
            if (canShowReverse) {
                int endOfFiberEventIndex = sFile.keyEvents.numberOfKeyEvents - 1;
                if (endOfFiberEventIndex < 0) {
                    canShowReverse = false;
                } else {
                    SorFile.KeyEventsItem event = sFile.keyEvents.events[endOfFiberEventIndex];
                    byte eventCode = event.eventCode[1];
                    if (68 != eventCode && 69 != eventCode && 100 != eventCode && 101 != eventCode) {
                        canShowReverse = false;
                    } else {
                        endOfFiberTime = event.eventPropagationTime;
                        endDataIndex = sFile.getTimeIndex(endOfFiberTime);
                    }
                }
            }
            if (!canShowReverse) {
                JOptionPane.showMessageDialog(this.mainFrame, this.getResourceString("ERR_CANT_SHOW_REVERSE"), this.getResourceString("titleString"), 0);
                this.setTwoWay(false);
                return;
            }
            rfgView.zoomX(0);
            rfgView.zoomY(0);
            int endOfFiberX = Math.round(sFile.getXStep() * (float)endDataIndex);
            float minData = Float.MAX_VALUE;
            float maxData = Float.MIN_VALUE;
            int i2 = 0;
            while (i2 < sFile.dataPts.numberOfDataPoints) {
                time = sFile.getIndexTime(i2);
                if (time > (float)endOfFiberTime) break;
                maxData = Math.max(maxData, sFile.dataPts.scaledData[i2]);
                minData = Math.min(minData, sFile.dataPts.scaledData[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < mFile.dataPts.numberOfDataPoints) {
                time = mFile.getIndexTime(i2);
                if (time > (float)endOfFiberTime) break;
                maxData = Math.max(maxData, mFile.dataPts.scaledData[i2]);
                minData = Math.min(minData, mFile.dataPts.scaledData[i2]);
                ++i2;
            }
            int y1 = Math.round(minData * sFile.getYStep() - sFile.dataPts.minData * sFile.getYStep());
            int y2 = Math.round(maxData * sFile.getYStep() - sFile.dataPts.minData * sFile.getYStep());
            this.createTwoWayKeyEvents(sFile, mFile);
            rfgView.zoom(0, y1, endOfFiberX, y2);
        } else {
            rfgView.invalidateView();
            this.otdrWindow.updateUI();
            this.updateZoomControls();
            this.updateOtdrControlPanel();
            this.updateScrolls();
        }
        this.otdrWindow.getRfgBackGroundPanel().reCreateOtdrEventsPanel();
    }

    private void createTwoWayKeyEvents(SorFile sFile, SorFile mFile) {
        this.twoWayKeyEvents = new SorFile.KeyEvents(sFile);
        this.twoWayKeyEvents.createKeyEventsItems(sFile.keyEvents.numberOfKeyEvents);
        int endEventIndex = sFile.keyEvents.numberOfKeyEvents - 1;
        int endEventTime = sFile.keyEvents.events[endEventIndex].eventPropagationTime;
        int pulseTime = Math.round(mFile.getIndexTime(sFile.getIndexAfterPulse(true)));
        int i = 0;
        while (i < sFile.keyEvents.numberOfKeyEvents) {
            int eventPropagationTime = endEventTime - sFile.keyEvents.events[i].eventPropagationTime;
            SorFile.KeyEventsItem event1 = sFile.keyEvents.events[i].copy();
            SorFile.KeyEventsItem event2 = null;
            try {
                event2 = mFile.keyEvents.getEventInNeighborhood(eventPropagationTime, pulseTime).copy();
            }
            catch (Exception e) {
                System.out.printf("can't getEventInNeighborhood: %s\n", e.getMessage());
            }
            if (event2 != null) {
                short attenuationCoefficientLeadInFiber = 0;
                int j = event2.eventNumber - 1;
                if (j < mFile.keyEvents.numberOfKeyEvents - 1) {
                    attenuationCoefficientLeadInFiber = mFile.keyEvents.events[j + 1].attenuationCoefficientLeadInFiber;
                }
                event1.attenuationCoefficientLeadInFiber = event1.attenuationCoefficientLeadInFiber == 0 || attenuationCoefficientLeadInFiber == 0 ? (short)0 : (short)Math.round(((double)event1.attenuationCoefficientLeadInFiber + (double)attenuationCoefficientLeadInFiber) / 2.0);
                event1.eventLoss = event1.eventLoss == 0 || event2.eventLoss == 0 ? (short)0 : (short)Math.round(((double)event1.eventLoss + (double)event2.eventLoss) / 2.0);
            }
            this.twoWayKeyEvents.events[i] = event1;
            ++i;
        }
    }

    public SorFile.KeyEvents getTwoWayKeyEvents() {
        return this.twoWayKeyEvents;
    }

    public boolean isTwoWayChecked() {
        boolean ret = this.menuItemEventsTwoWay == null ? false : this.menuItemEventsTwoWay.isSelected();
        return ret;
    }

    public void setTwoWay(boolean to) {
        this.menuItemEventsTwoWay.setSelected(to);
        this.updateTwoWayCheckMenuItem();
        this.menuEventsTwoWayChanged();
    }

    public void openSorFile(String filePath, int index) {
        int res;
        this.sorFile[index].loadSorFileBuffer(filePath);
        this.sorFile[index].filePath = filePath;
        boolean isGoodCRC = this.sorFile[index].verifyCheckSum(true);
        if (!isGoodCRC && (res = JOptionPane.showConfirmDialog(this.otdrWindow, this.getResourceString("FILE_CRC_ERROR_CONTINUE_OR_NOT"), this.getResourceString("titleString"), 0, 3)) == 0) {
            isGoodCRC = true;
        }
        if (isGoodCRC) {
            if (this.sorFile[index].extractSorFile()) {
                this.sorFile[index].setDefaultMeasureParameters(this);
                this.otdrControlPanel.setRfgChecked(index, true);
                this.updateAll();
                this.otdrControlPanel.setRfgChecked(this.currentSorFileIndex, true);
                if (this.client != null && this.client.isConnected()) {
                    this.saveToolBarAndMenuState();
                    this.updateMesauringMenuAndToolBar(InstrumentState.SETTING);
                    this.client.setMeasuringParametersAccordingSorFile(this.sorFile[index]);
                    this.restoreToolBarAndMenuState();
                }
            } else {
                JOptionPane.showMessageDialog(this.mainFrame, this.getResourceString("FILE_FROMAT_ERROR"), this.getResourceString("titleString"), 0);
            }
        } else {
            JOptionPane.showMessageDialog(this.mainFrame, this.getResourceString("FILE_CRC_ERROR"), this.getResourceString("titleString"), 0);
        }
    }

    private void saveCurrentDirectory() {
        if (this.currentDirectory == null) {
            return;
        }
        try {
            String defaultFolder = String.valueOf(FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath()) + File.separator + this.getResourceString("ourOwnFolderName");
            File dir = new File(defaultFolder);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileOutputStream fo = new FileOutputStream(String.valueOf(defaultFolder) + File.separator + sorFilesPathFile);
            ObjectOutputStream oos = new ObjectOutputStream(fo);
            oos.writeObject(this.currentDirectory);
            oos.flush();
        }
        catch (Exception exc) {
            String tmpS = String.format(":\n%s", exc.getMessage());
            tmpS = String.valueOf(this.getResourceString("Error")) + tmpS;
            JOptionPane.showMessageDialog(this.mainFrame, tmpS, "OTDR View", 0);
            System.out.printf("Exception:%s\n", exc.getMessage());
            this.currentDirectory = null;
        }
    }

    private void loadCurrentDirectory() {
        try {
            String defaultFolder = String.valueOf(FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath()) + File.separator + this.getResourceString("ourOwnFolderName");
            FileInputStream fi = new FileInputStream(String.valueOf(defaultFolder) + File.separator + sorFilesPathFile);
            ObjectInputStream iis = new ObjectInputStream(fi);
            this.currentDirectory = (File)iis.readObject();
        }
        catch (Exception e) {
            System.out.printf("can't deserialize currentDirectory:%s\n", e.getMessage());
            this.currentDirectory = null;
        }
    }

    public void openSorFile() {
        JFileChooser fileChooser = new JFileChooser();
        FilePreviewer previewer = new FilePreviewer(this, fileChooser);
        fileChooser.setAccessory(previewer);
        fileChooser.setCurrentDirectory(this.currentDirectory);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(this.sorFilter);
        fileChooser.setDialogTitle(this.getResourceString("openDialogString"));
        if (fileChooser.showOpenDialog(this.mainFrame) != 0) {
            return;
        }
        this.currentDirectory = fileChooser.getCurrentDirectory();
        if (fileChooser.getSelectedFiles() != null) {
            if (fileChooser.getSelectedFiles().length == 1) {
                this.openSorFile(fileChooser.getSelectedFiles()[0].getPath(), this.currentSorFileIndex);
            } else {
                int i = 0;
                while (i < fileChooser.getSelectedFiles().length) {
                    if (this.sorFile.length <= i) break;
                    this.openSorFile(fileChooser.getSelectedFiles()[i].getPath(), i);
                    ++i;
                }
            }
            if (this.isTwoWayChecked()) {
                this.menuEventsTwoWayChanged();
            }
        }
    }

    public void closeSorFile(int index) {
        this.otdrControlPanel.setRfgChecked(index, false);
        this.sorFile[index] = null;
        this.sorFile[index] = new SorFile();
        this.updateAll();
    }

    public void closeAllSorFiles() {
        int i = 0;
        while (i < this.sorFile.length) {
            this.otdrControlPanel.setRfgChecked(i, false);
            this.sorFile[i] = null;
            this.sorFile[i] = new SorFile();
            ++i;
        }
        this.updateAll();
    }

    public void saveSorFile(int index) {
        this.mainFrame.setCursor(new Cursor(3));
        this.sorFile[index].saveSorFileBuffer(this.sorFile[index].filePath);
        this.mainFrame.setCursor(new Cursor(0));
    }

    public void saveSorFileAS(int index) {
        String[] extentions = new String[]{"csv"};
        FileFilter csvFilter = this.createFileFilter("CSV File", true, extentions);
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogType(1);
        fileChooser.setCurrentDirectory(this.currentDirectory);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(this.sorFilter);
        fileChooser.addChoosableFileFilter(csvFilter);
        fileChooser.setFileFilter(this.sorFilter);
        fileChooser.setSelectedFile(new File(this.sorFile[index].filePath));
        fileChooser.setDialogTitle(this.getResourceString("saveDialogString"));
        if (fileChooser.showSaveDialog(this.mainFrame) != 0) {
            return;
        }
        this.currentDirectory = fileChooser.getCurrentDirectory();
        if (fileChooser.getSelectedFile() != null) {
            String filePath = fileChooser.getSelectedFile().getPath();
            File file = new File(filePath);
            if (file.exists()) {
                String message = String.format("\n%s\n", filePath);
                message = String.valueOf(this.getResourceString("fileExistsString")) + ":" + message + this.getResourceString("overwriteString") + "?";
                int res = JOptionPane.showConfirmDialog(this.otdrWindow, message, "OTDR View", 0, 3);
                if (res != 0) {
                    return;
                }
            }
            if (fileChooser.getFileFilter() == this.sorFilter) {
                if (!filePath.toLowerCase().contains(".sor")) {
                    filePath = String.valueOf(filePath) + ".sor";
                }
                this.sorFile[index].filePath = filePath;
                this.saveSorFile(index);
                this.mainFrame.setTitle(String.valueOf(this.getResourceString("titleString")) + " - " + this.sorFile[index].getFileName());
            } else if (fileChooser.getFileFilter() == csvFilter) {
                if (!filePath.toLowerCase().contains(".csv")) {
                    filePath = String.valueOf(filePath) + ".csv";
                }
                this.mainFrame.setCursor(new Cursor(3));
                this.sorFile[index].saveCSVFile(filePath);
                this.mainFrame.setCursor(new Cursor(0));
            } else {
                System.out.println("Unreleased file filter case!!!");
            }
        }
    }

    public void printPreview() {
    }

    public void pageFormat() {
        if (this.pj == null) {
            this.pj = PrinterJob.getPrinterJob();
        }
        if (this.pf == null) {
            this.pf = this.pj.defaultPage();
        }
        this.pf = this.pj.pageDialog(this.pf);
    }

    public void print() {
        if (this.pj == null) {
            this.pj = PrinterJob.getPrinterJob();
        }
        if (this.pf == null) {
            this.pf = this.pj.pageDialog(this.pj.defaultPage());
        }
        this.pj.setPrintable(this.otdrWindow.getRfgBackGroundPanel().getRfgView(), this.pf);
        this.pj.setCopies(1);
        if (this.pj.printDialog()) {
            try {
                this.pj.print();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public void updateScrolls() {
        int referenceSorFileIndex = this.getReferenceSorFileIndex();
        SorFile sorFile = this.getSorFile(referenceSorFileIndex);
        if (sorFile == null) {
            return;
        }
        if (sorFile.dataPts == null) {
            return;
        }
        if (!sorFile.isDataPtsPresent) {
            return;
        }
        int blockIncrement = 0;
        int unitIncrement = 0;
        JScrollBar hBar = this.otdrWindow.getRfgBackGroundPanel().getHorizontalBar();
        JScrollBar vBar = this.otdrWindow.getRfgBackGroundPanel().getVerticalBar();
        hBar.removeAdjustmentListener(this.otdrWindow.getRfgBackGroundPanel().adjustmentListener);
        hBar.setMinimum(0);
        hBar.setMaximum(Math.round((Float.valueOf(this.xScale).floatValue() - 1.0f) * (float)sorFile.dataPts.numberOfDataPoints));
        hBar.setValue(Math.round(Float.valueOf(this.xScale).floatValue() * (float)sorFile.indexOffset));
        hBar.addAdjustmentListener(this.otdrWindow.getRfgBackGroundPanel().adjustmentListener);
        blockIncrement = (hBar.getMaximum() - hBar.getMinimum()) / 10;
        unitIncrement = (hBar.getMaximum() - hBar.getMinimum()) / 100;
        hBar.setBlockIncrement(blockIncrement);
        hBar.setUnitIncrement(unitIncrement);
        vBar.removeAdjustmentListener(this.otdrWindow.getRfgBackGroundPanel().adjustmentListener);
        vBar.setMinimum(0);
        vBar.setMaximum(sorFile.maxYOffset);
        vBar.setValue(sorFile.yOffset);
        vBar.addAdjustmentListener(this.otdrWindow.getRfgBackGroundPanel().adjustmentListener);
        blockIncrement = (vBar.getMaximum() - vBar.getMinimum()) / 10;
        unitIncrement = (vBar.getMaximum() - vBar.getMinimum()) / 100;
        vBar.setBlockIncrement(blockIncrement);
        vBar.setUnitIncrement(unitIncrement);
    }

    public void updateZoomControls() {
        this.toolButtonZoomOff.setEnabled(false);
        this.toolButtonZoomInX.setEnabled(false);
        this.toolButtonZoomOutX.setEnabled(false);
        this.toolButtonZoomInY.setEnabled(false);
        this.toolButtonZoomOutY.setEnabled(false);
        int referenceSorFileIndex = this.getReferenceSorFileIndex();
        SorFile sorFile = this.getSorFile(referenceSorFileIndex);
        if (sorFile == null) {
            return;
        }
        if (sorFile.dataPts == null) {
            return;
        }
        if (!sorFile.isDataPtsPresent) {
            return;
        }
        this.toolButtonZoomMode.setEnabled(true);
        this.toolButtonZoomOff.setEnabled(this.canXZoomOut() || this.canYZoomOut());
        this.toolButtonZoomInX.setEnabled(this.canXZoomIn());
        this.toolButtonZoomOutX.setEnabled(this.canXZoomOut());
        this.toolButtonZoomInY.setEnabled(this.canYZoomIn());
        this.toolButtonZoomOutY.setEnabled(this.canYZoomOut());
    }

    public boolean isZoomMode() {
        return this.toolButtonZoomMode.isSelected() && this.toolButtonZoomMode.isEnabled();
    }

    public void setZoomMode(boolean to) {
        this.toolButtonZoomMode.setSelected(to);
    }

    public void updateOtdrControlPanel() {
        int rightCursor;
        int leftCursor;
        int referenceSorFileIndex = this.getReferenceSorFileIndex();
        SorFile sorFile = this.getSorFile(referenceSorFileIndex);
        if (sorFile == null || sorFile.dataPts == null || !sorFile.isDataPtsPresent) {
            Component[] componentArray = this.otdrControlPanel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                if (comp instanceof JTextField) {
                    ((JTextField)comp).setText("");
                }
                ++n2;
            }
            return;
        }
        if (sorFile.cursor[1].getDataIndex() > sorFile.cursor[0].getDataIndex()) {
            leftCursor = sorFile.cursor[0].getDataIndex();
            rightCursor = sorFile.cursor[1].getDataIndex();
        } else {
            rightCursor = sorFile.cursor[0].getDataIndex();
            leftCursor = sorFile.cursor[1].getDataIndex();
        }
        float distanceL = (float)sorFile.recalcDistance(leftCursor);
        this.otdrControlPanel.updateLeftCursor(distanceL);
        float distanceR = (float)sorFile.recalcDistance(rightCursor);
        this.otdrControlPanel.updateRightCursor(distanceR);
        float distance = Math.abs(distanceR - distanceL);
        this.otdrControlPanel.updateRightToLeftCursor(distance);
        float attenuationBetweenCursors = sorFile.dataPts.scaledData[rightCursor] - sorFile.dataPts.scaledData[leftCursor];
        float attenuationCoefficient = attenuationBetweenCursors / distance;
        switch (this.measureMode) {
            case MEASURE_MODE_2P_LOSS: {
                String tmpS = String.format("%.3f", Float.valueOf(attenuationBetweenCursors));
                this.otdrControlPanel.setMiscParametersValue(3, tmpS);
                tmpS = Float.isNaN(attenuationCoefficient) ? "" : String.format("%.3f", Float.valueOf(attenuationCoefficient));
                this.otdrControlPanel.setMiscParametersValue(4, tmpS);
                break;
            }
            case MEASURE_MODE_APPROX_LOSS: {
                sorFile.lsaLine[0] = sorFile.getLSALine(sorFile.cursor[0].getDataIndex(), sorFile.cursor[1].getDataIndex());
                float lsaApproxLoss = sorFile.lsaLine[0].getY(rightCursor) - sorFile.lsaLine[0].getY(leftCursor);
                String tmpS = Float.isNaN(lsaApproxLoss) ? "" : String.format("%.3f", Float.valueOf(lsaApproxLoss));
                this.otdrControlPanel.setMiscParametersValue(3, tmpS);
                float lsaApproxLossAttunCoeff = lsaApproxLoss / distance;
                tmpS = Float.isNaN(lsaApproxLossAttunCoeff) ? "" : String.format("%.3f", Float.valueOf(lsaApproxLossAttunCoeff));
                this.otdrControlPanel.setMiscParametersValue(4, tmpS);
                break;
            }
            case MEASURE_MODE_LSA_LOSS: {
                sorFile.lsaLine[0] = sorFile.getLSALine(sorFile.cursor[2].getDataIndex(), sorFile.cursor[0].getDataIndex());
                sorFile.lsaLine[1] = sorFile.getLSALine(sorFile.cursor[3].getDataIndex(), sorFile.cursor[1].getDataIndex());
                float lsaLoss = sorFile.lsaLine[1].getY(sorFile.cursor[4].getDataIndex()) - sorFile.lsaLine[0].getY(sorFile.cursor[4].getDataIndex());
                String tmpS = Float.isNaN(lsaLoss) ? "" : String.format("%.3f", Float.valueOf(lsaLoss));
                this.otdrControlPanel.setMiscParametersValue(3, tmpS);
                float lsaDistance = (float)sorFile.recalcDistance(sorFile.cursor[4].getDataIndex());
                tmpS = Float.isNaN(lsaDistance) ? "" : String.format("%.4f", Float.valueOf(lsaDistance));
                this.otdrControlPanel.setMiscParametersValue(4, tmpS);
                break;
            }
            case MEASURE_MODE_REFLECTANCE: {
                float reflectance = sorFile.calcReflectance(leftCursor, rightCursor);
                String tmpS = Float.isInfinite(reflectance) || Float.isNaN(reflectance) ? "" : String.format("%.3f", Float.valueOf(reflectance));
                this.otdrControlPanel.setMiscParametersValue(3, tmpS);
                tmpS = String.format("%.4f", Float.valueOf(distanceL));
                this.otdrControlPanel.setMiscParametersValue(4, tmpS);
                break;
            }
            case MEASURE_MODE_ORL: {
                float orl = sorFile.calcORL(leftCursor, rightCursor);
                String tmpS = String.format("%.3f", Float.valueOf(attenuationBetweenCursors));
                this.otdrControlPanel.setMiscParametersValue(3, tmpS);
                tmpS = Float.isNaN(orl) ? "" : String.format("%.3f", Float.valueOf(orl));
                this.otdrControlPanel.setMiscParametersValue(4, tmpS);
                break;
            }
        }
    }

    private String createFileNameFilterDescriptionFromExtensions(String description, String[] extensions) {
        String fullDescription = description == null ? "(" : String.valueOf(description) + " (";
        fullDescription = String.valueOf(fullDescription) + "." + extensions[0];
        int i = 1;
        while (i < extensions.length) {
            fullDescription = String.valueOf(fullDescription) + ", .";
            fullDescription = String.valueOf(fullDescription) + extensions[i];
            ++i;
        }
        fullDescription = String.valueOf(fullDescription) + ")";
        return fullDescription;
    }

    private FileFilter createFileFilter(String description, boolean showExtensionInDescription, String[] extensions) {
        if (showExtensionInDescription) {
            description = this.createFileNameFilterDescriptionFromExtensions(description, extensions);
        }
        return new FileNameExtensionFilter(description, extensions);
    }

    protected String getResourceString(String nm) {
        String str;
        try {
            str = resources.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = nm;
        }
        return str;
    }

    protected URL getResource(String key) {
        String name = this.getResourceString(key);
        if (name != null) {
            URL url = this.getClass().getResource(name);
            return url;
        }
        return null;
    }

    public char getMnemonic(String key) {
        return this.getResourceString(key).charAt(0);
    }

    public void saveToolBarAndMenuState() {
        if (this.menuBarElementState == null) {
            this.menuBarElementState = new boolean[this.mainFrame.getJMenuBar().getMenuCount()];
        }
        int i = 0;
        while (i < this.mainFrame.getJMenuBar().getMenuCount()) {
            this.menuBarElementState[i] = this.mainFrame.getJMenuBar().getMenu(i).isEnabled();
            ++i;
        }
        if (this.toolBarElementState == null) {
            this.toolBarElementState = new boolean[this.toolBar.getComponentCount()];
        }
        i = 0;
        while (i < this.toolBar.getComponentCount()) {
            this.toolBarElementState[i] = this.toolBar.getComponent(i).isEnabled();
            ++i;
        }
    }

    public void restoreToolBarAndMenuState() {
        if (this.menuBarElementState == null) {
            return;
        }
        if (this.toolBarElementState == null) {
            return;
        }
        int i = 0;
        while (i < this.mainFrame.getJMenuBar().getMenuCount()) {
            this.mainFrame.getJMenuBar().getMenu(i).setEnabled(this.menuBarElementState[i]);
            ++i;
        }
        i = 0;
        while (i < this.toolBar.getComponentCount()) {
            this.toolBar.getComponent(i).setEnabled(this.toolBarElementState[i]);
            ++i;
        }
    }

    public void updateMesauringMenuAndToolBar(InstrumentState instrumentState) {
        if (InstrumentState.DISCONNECTED == instrumentState) {
            this.updateMesauringMenuAndToolBar(false);
        } else if (InstrumentState.CONNECTED == instrumentState) {
            this.updateMesauringMenuAndToolBar(true);
        } else if (InstrumentState.MEASURING == instrumentState) {
            this.menuItemsMeasuring[0].setEnabled(false);
            this.menuItemsMeasuring[1].setEnabled(false);
            this.menuItemsMeasuring[3].setEnabled(false);
            this.menuItemsMeasuring[4].setEnabled(false);
            this.menuItemsMeasuring[7].setEnabled(false);
            this.menuItemsMeasuring[5].setEnabled(true);
            this.toolButtonConnectInstrument.setEnabled(false);
            this.toolButtonDisconnectInstrument.setEnabled(false);
            this.toolButtonStartMeasureAver.setEnabled(false);
            this.toolButtonStartMeasureLive.setEnabled(false);
            this.toolButtonMeasureParameters.setEnabled(false);
            this.toolButtonStopMeasure.setEnabled(true);
        } else if (InstrumentState.STOPPING_MEASURING == instrumentState) {
            int i = 0;
            while (i < this.menuItemsMeasuring.length) {
                if (menuMeasuringStrings[i + 1] != "-") {
                    this.menuItemsMeasuring[i].setEnabled(false);
                }
                ++i;
            }
            this.toolButtonConnectInstrument.setEnabled(false);
            this.toolButtonDisconnectInstrument.setEnabled(false);
            this.toolButtonStartMeasureAver.setEnabled(false);
            this.toolButtonStartMeasureLive.setEnabled(false);
            this.toolButtonMeasureParameters.setEnabled(false);
            this.toolButtonStopMeasure.setEnabled(false);
        } else if (InstrumentState.SETTING == instrumentState) {
            int i = 0;
            while (i < this.mainFrame.getJMenuBar().getMenuCount()) {
                this.mainFrame.getJMenuBar().getMenu(i).setEnabled(false);
                ++i;
            }
            i = 0;
            while (i < this.toolBar.getComponentCount()) {
                this.toolBar.getComponent(i).setEnabled(false);
                ++i;
            }
        } else {
            JOptionPane.showMessageDialog(this.mainFrame, this.getResourceString("updateMesauringMenuAndToolBar error"), this.getResourceString("titleString"), 0);
        }
    }

    private void updateMesauringMenuAndToolBar(boolean connected) {
        this.menuItemsMeasuring[0].setEnabled(!connected);
        int i = 1;
        while (i < this.menuItemsMeasuring.length) {
            if (menuMeasuringStrings[i + 1] != "-") {
                this.menuItemsMeasuring[i].setEnabled(connected);
            }
            ++i;
        }
        this.menuItemsMeasuring[5].setEnabled(false);
        this.toolButtonConnectInstrument.setEnabled(!connected);
        this.toolButtonDisconnectInstrument.setEnabled(connected);
        this.toolButtonStartMeasureAver.setEnabled(connected);
        this.toolButtonStartMeasureLive.setEnabled(connected);
        this.toolButtonMeasureParameters.setEnabled(connected);
        this.toolButtonStopMeasure.setEnabled(false);
    }

    private void createMenu() {
        JMenuItem menuItem;
        JMenuItem menuItem2;
        JMenuBar menuBar = new JMenuBar();
        int i = 0;
        this.menuFile = new JMenu(this.getResourceString(menuFileStrings[i]));
        ++i;
        while (menuFileStrings[i] != null) {
            if (menuFileStrings[i] == "-") {
                this.menuFile.addSeparator();
            } else {
                menuItem2 = new JMenuItem(this.getResourceString(menuFileStrings[i]));
                menuItem2.setName(menuFileStrings[i]);
                menuItem2.addActionListener(this.actionListener);
                menuItem2.setIcon(this.loadImageIcon(String.valueOf(menuFileStrings[i]) + "Image"));
                if (3 == i) {
                    this.menuItemCloseAllFiles = menuItem2;
                } else if (2 == i) {
                    this.menuItemCloseFile = menuItem2;
                } else if (5 == i) {
                    this.menuItemSave = menuItem2;
                } else if (6 == i) {
                    this.menuItemSaveAS = menuItem2;
                } else if (9 == i) {
                    this.menuItemPrint = menuItem2;
                } else if (11 == i) {
                    this.menuItemInformation = menuItem2;
                } else if (12 == i) {
                    this.menuItemTemplateParameters = menuItem2;
                }
                this.menuFile.add(menuItem2);
            }
            ++i;
        }
        menuBar.add(this.menuFile);
        i = 0;
        this.menuMeasuring = new JMenu(this.getResourceString(menuMeasuringStrings[i]));
        this.menuItemsMeasuring = new JMenuItem[menuMeasuringStrings.length - 2];
        ++i;
        while (menuMeasuringStrings[i] != null) {
            if (menuMeasuringStrings[i] == "-") {
                this.menuMeasuring.addSeparator();
            } else {
                menuItem2 = new JMenuItem(this.getResourceString(menuMeasuringStrings[i]));
                menuItem2.setName(menuMeasuringStrings[i]);
                menuItem2.addActionListener(this.actionListener);
                menuItem2.setIcon(this.loadImageIcon(String.valueOf(menuMeasuringStrings[i]) + "Image"));
                this.menuMeasuring.add(menuItem2);
                this.menuItemsMeasuring[i - 1] = menuItem2;
            }
            ++i;
        }
        menuBar.add(this.menuMeasuring);
        this.updateMesauringMenuAndToolBar(false);
        this.menuMode = new JMenu(this.getResourceString("menuMode"));
        this.menuMode.setMnemonic(this.getMnemonic("menuModeMnemonic"));
        ButtonGroup bgMeasureMode = new ButtonGroup();
        this.measureModeMenuItems = new JRadioButtonMenuItem[menuModeStrings.length];
        i = 0;
        while (i < menuModeStrings.length) {
            if (menuModeStrings[i] == "-") {
                this.menuMode.addSeparator();
            } else {
                this.measureModeMenuItems[i] = new JRadioButtonMenuItem(this.getResourceString(menuModeStrings[i]));
                this.measureModeMenuItems[i].setName(menuModeStrings[i]);
                this.measureModeMenuItems[i].addActionListener(this.actionListener);
                this.measureModeMenuItems[i].setIcon(this.loadImageIcon(String.valueOf(menuModeStrings[i]) + "Image"));
                if (menuModeItems[i] == this.measureMode) {
                    this.measureModeMenuItems[i].setSelected(true);
                }
                bgMeasureMode.add(this.measureModeMenuItems[i]);
                this.menuMode.add(this.measureModeMenuItems[i]);
            }
            ++i;
        }
        this.menuMode.addSeparator();
        JMenuItem menuItemModeRI = new JMenuItem(this.getResourceString("menuModeRI"));
        menuItemModeRI.setName("menuModeRI");
        menuItemModeRI.addActionListener(this.actionListener);
        ImageIcon iconModeRI = this.loadImageIcon("menuModeRIImage");
        if (iconModeRI != null) {
            menuItemModeRI.setIcon(iconModeRI);
        }
        this.menuMode.add(menuItemModeRI);
        menuBar.add(this.menuMode);
        i = 0;
        this.menuEvents = new JMenu(this.getResourceString(menuEventsStrings[i]));
        this.menuEvents.setMnemonic(this.getMnemonic("menuEventsMnemonic"));
        ++i;
        while (menuEventsStrings.length > i) {
            if ("-" == menuEventsStrings[i]) {
                this.menuEvents.addSeparator();
            } else {
                menuItem = 3 == i || 7 == i ? new JCheckBoxMenuItem(this.getResourceString(menuEventsStrings[i])) : new JMenuItem(this.getResourceString(menuEventsStrings[i]));
                ((JMenuItem)menuItem).setName(menuEventsStrings[i]);
                ((JMenuItem)menuItem).addActionListener(this.actionListener);
                ((JMenuItem)menuItem).setIcon(this.loadImageIcon(String.valueOf(menuEventsStrings[i]) + "Image"));
                if (3 == i) {
                    this.menuItemEventsTable = menuItem;
                    this.menuItemEventsTable.setSelected(this.otdrWindow.otdrEventsPanel.isVisible());
                } else if (7 == i) {
                    this.menuItemEventsTwoWay = menuItem;
                    this.menuItemEventsTwoWay.setSelected(false);
                } else if (1 == i) {
                    this.menuItemFixEvent = menuItem;
                }
                this.menuEvents.add(menuItem);
            }
            ++i;
        }
        menuBar.add(this.menuEvents);
        i = 0;
        this.menuTools = new JMenu(this.getResourceString(menuToolsStrings[i]));
        this.menuTools.setMnemonic((int)this.getMnemonic("menuToolsMnemonic"));
        ++i;
        while (menuToolsStrings[i] != null) {
            if (menuFileStrings[i] == "-") {
                this.menuFile.addSeparator();
            } else if (1 == i) {
                menuItem = new JCheckBoxMenuItem(this.getResourceString(menuToolsStrings[i]));
                menuItem.setName(menuToolsStrings[i]);
                menuItem.addActionListener(this.actionListener);
                this.menuTools.add(menuItem);
                menuItem.setSelected(true);
                this.menuItemAutosearch = menuItem;
            } else if (2 == i) {
                menuItem = new JCheckBoxMenuItem(this.getResourceString(menuToolsStrings[i]));
                menuItem.setName(menuToolsStrings[i]);
                menuItem.addActionListener(this.actionListener);
                this.menuTools.add(menuItem);
                menuItem.setSelected(false);
                this.menuItemFixCursors = menuItem;
            } else {
                menuItem = new JMenuItem(this.getResourceString(menuToolsStrings[i]));
                menuItem.setName(menuToolsStrings[i]);
                menuItem.addActionListener(this.actionListener);
                menuItem.setIcon(this.loadImageIcon(String.valueOf(menuToolsStrings[i]) + "Image"));
                this.menuTools.add(menuItem);
            }
            ++i;
        }
        menuBar.add(this.menuTools);
        this.menuLookAndFeel = new JMenu(this.getResourceString("menuLookAndFeel"));
        this.menuLookAndFeel.setMnemonic(this.getMnemonic("menuLookAndFeelMnemonic"));
        ButtonGroup bgLAF = new ButtonGroup();
        this.lafMenuItems = new JRadioButtonMenuItem[this.lookAndFeelInfos.length];
        i = 0;
        while (i < this.lookAndFeelInfos.length) {
            this.lafMenuItems[i] = new JRadioButtonMenuItem(this.lookAndFeelInfos[i].getName());
            this.lafMenuItems[i].setName("LookAndFeel_" + this.lookAndFeelInfos[i].getName());
            this.lafMenuItems[i].addActionListener(this.actionListener);
            if (this.lookAndFeelInfos[i].getName() == UIManager.getLookAndFeel().getName()) {
                this.lafMenuItems[i].setSelected(true);
            }
            bgLAF.add(this.lafMenuItems[i]);
            this.menuLookAndFeel.add(this.lafMenuItems[i]);
            ++i;
        }
        menuBar.add(this.menuLookAndFeel);
        i = 0;
        this.menuHelp = new JMenu(this.getResourceString(menuHelpStrings[i]));
        this.menuHelp.setMnemonic(this.getMnemonic("menuHelpMnemonic"));
        ++i;
        while (menuHelpStrings.length > i) {
            if ("-" == menuHelpStrings[i]) {
                this.menuHelp.addSeparator();
            } else {
                JMenuItem menuItem3 = new JMenuItem(this.getResourceString(menuHelpStrings[i]));
                menuItem3.setName(menuHelpStrings[i]);
                menuItem3.addActionListener(this.actionListener);
                menuItem3.setIcon(this.loadImageIcon(String.valueOf(menuHelpStrings[i]) + "Image"));
                this.menuHelp.add(menuItem3);
            }
            ++i;
        }
        menuBar.add(this.menuHelp);
        this.mainFrame.setJMenuBar(menuBar);
    }

    private void createToolBar() {
        this.toolBar = new JToolBar();
        this.toolButtonOpen = new JButton(this.loadImageIcon("menuFileOpenImage"));
        this.toolButtonOpen.setName(menuFileStrings[1]);
        this.toolButtonOpen.addActionListener(this.actionListener);
        this.toolButtonOpen.setToolTipText(this.getResourceString(menuFileToolTipStrings[1]));
        this.toolBar.add(this.toolButtonOpen);
        this.toolButtonSave = new JButton(this.loadImageIcon("menuFileSaveImage"));
        this.toolButtonSave.setName(menuFileStrings[5]);
        this.toolButtonSave.addActionListener(this.actionListener);
        this.toolButtonSave.setToolTipText(this.getResourceString(menuFileToolTipStrings[5]));
        this.toolBar.add(this.toolButtonSave);
        this.toolButtonInformation = new JButton(this.loadImageIcon("menuFileInformationImage"));
        this.toolButtonInformation.setName(menuFileStrings[11]);
        this.toolButtonInformation.addActionListener(this.actionListener);
        this.toolButtonInformation.setToolTipText(this.getResourceString(menuFileToolTipStrings[11]));
        this.toolBar.add(this.toolButtonInformation);
        this.toolBar.addSeparator();
        this.toolButtonConnectInstrument = new JButton(this.loadImageIcon("menuMeasuringConnectImage"));
        this.toolButtonConnectInstrument.setName(menuMeasuringStrings[1]);
        this.toolButtonConnectInstrument.addActionListener(this.actionListener);
        this.toolButtonConnectInstrument.setToolTipText(this.getResourceString(menuMeasuringToolTipStrings[1]));
        this.toolBar.add(this.toolButtonConnectInstrument);
        this.toolButtonDisconnectInstrument = new JButton(this.loadImageIcon("menuMeasuringDisconnectImage"));
        this.toolButtonDisconnectInstrument.setName(menuMeasuringStrings[2]);
        this.toolButtonDisconnectInstrument.addActionListener(this.actionListener);
        this.toolButtonDisconnectInstrument.setToolTipText(this.getResourceString(menuMeasuringToolTipStrings[2]));
        this.toolBar.add(this.toolButtonDisconnectInstrument);
        this.toolButtonStartMeasureAver = new JButton(this.loadImageIcon("menuMeasuringStartAverImage"));
        this.toolButtonStartMeasureAver.setName(menuMeasuringStrings[4]);
        this.toolButtonStartMeasureAver.addActionListener(this.actionListener);
        this.toolButtonStartMeasureAver.setToolTipText(this.getResourceString(menuMeasuringToolTipStrings[4]));
        this.toolBar.add(this.toolButtonStartMeasureAver);
        this.toolButtonStartMeasureLive = new JButton(this.loadImageIcon("menuMeasuringStartLiveImage"));
        this.toolButtonStartMeasureLive.setName(menuMeasuringStrings[5]);
        this.toolButtonStartMeasureLive.addActionListener(this.actionListener);
        this.toolButtonStartMeasureLive.setToolTipText(this.getResourceString(menuMeasuringToolTipStrings[5]));
        this.toolBar.add(this.toolButtonStartMeasureLive);
        this.toolButtonStopMeasure = new JButton(this.loadImageIcon("menuMeasuringStopImage"));
        this.toolButtonStopMeasure.setName(menuMeasuringStrings[6]);
        this.toolButtonStopMeasure.addActionListener(this.actionListener);
        this.toolButtonStopMeasure.setToolTipText(this.getResourceString(menuMeasuringToolTipStrings[6]));
        this.toolBar.add(this.toolButtonStopMeasure);
        this.toolButtonMeasureParameters = new JButton(this.loadImageIcon("menuMeasuringParametersImage"));
        this.toolButtonMeasureParameters.setName(menuMeasuringStrings[8]);
        this.toolButtonMeasureParameters.addActionListener(this.actionListener);
        this.toolButtonMeasureParameters.setToolTipText(this.getResourceString(menuMeasuringToolTipStrings[8]));
        this.toolBar.add(this.toolButtonMeasureParameters);
        this.toolBar.addSeparator();
        this.toolButtonZoomInX = new JButton(this.loadImageIcon("menuZoomInXImage"));
        this.toolButtonZoomInX.setName("menuZoomInX");
        this.toolButtonZoomInX.addActionListener(this.actionListener);
        this.toolButtonZoomInX.setEnabled(false);
        this.toolButtonZoomInX.setToolTipText(this.getResourceString("toolButtonZoomInXToolTip"));
        this.toolBar.add(this.toolButtonZoomInX);
        this.toolButtonZoomOutX = new JButton(this.loadImageIcon("menuZoomOutXImage"));
        this.toolButtonZoomOutX.setName("menuZoomOutX");
        this.toolButtonZoomOutX.addActionListener(this.actionListener);
        this.toolButtonZoomOutX.setEnabled(false);
        this.toolButtonZoomOutX.setToolTipText(this.getResourceString("toolButtonZoomOutXToolTip"));
        this.toolBar.add(this.toolButtonZoomOutX);
        this.toolButtonZoomInY = new JButton(this.loadImageIcon("menuZoomInYImage"));
        this.toolButtonZoomInY.setName("menuZoomInY");
        this.toolButtonZoomInY.addActionListener(this.actionListener);
        this.toolButtonZoomInY.setEnabled(false);
        this.toolButtonZoomInY.setToolTipText(this.getResourceString("toolButtonZoomInYToolTip"));
        this.toolBar.add(this.toolButtonZoomInY);
        this.toolButtonZoomOutY = new JButton(this.loadImageIcon("menuZoomOutYImage"));
        this.toolButtonZoomOutY.setName("menuZoomOutY");
        this.toolButtonZoomOutY.addActionListener(this.actionListener);
        this.toolButtonZoomOutY.setEnabled(false);
        this.toolButtonZoomOutY.setToolTipText(this.getResourceString("toolButtonZoomOutYToolTip"));
        this.toolBar.add(this.toolButtonZoomOutY);
        this.toolButtonZoomMode = new JToggleButton(this.loadImageIcon("menuZoomModeImage"));
        this.toolButtonZoomMode.setSelected(false);
        this.toolButtonZoomMode.setName("menuZoomMode");
        this.toolButtonZoomMode.addActionListener(this.actionListener);
        this.toolButtonZoomMode.setEnabled(false);
        this.toolButtonZoomMode.setToolTipText(this.getResourceString("toolButtonZoomModeToolTip"));
        this.toolBar.add(this.toolButtonZoomMode);
        this.toolButtonZoomOff = new JButton(this.loadImageIcon("menuZoomOffImage"));
        this.toolButtonZoomOff.setName("menuZoomOff");
        this.toolButtonZoomOff.addActionListener(this.actionListener);
        this.toolButtonZoomOff.setEnabled(false);
        this.toolButtonZoomOff.setToolTipText(this.getResourceString("toolButtonZoomOffToolTip"));
        this.toolBar.add(this.toolButtonZoomOff);
        this.toolBar.addSeparator();
        ButtonGroup bgMode = new ButtonGroup();
        this.toolButtonMode2P = new JToggleButton(this.loadImageIcon("menuMode2PImage"));
        this.toolButtonMode2P.setName(menuModeStrings[0]);
        this.toolButtonMode2P.addActionListener(this.actionListener);
        this.toolButtonMode2P.setToolTipText(this.getResourceString(menuModeToolTipStrings[0]));
        bgMode.add(this.toolButtonMode2P);
        this.toolBar.add(this.toolButtonMode2P);
        this.toolButtonModeLSALine = new JToggleButton(this.loadImageIcon("menuModeLSALineImage"));
        this.toolButtonModeLSALine.setName(menuModeStrings[1]);
        this.toolButtonModeLSALine.addActionListener(this.actionListener);
        this.toolButtonModeLSALine.setToolTipText(this.getResourceString(menuModeToolTipStrings[1]));
        bgMode.add(this.toolButtonModeLSALine);
        this.toolBar.add(this.toolButtonModeLSALine);
        this.toolButtonModeLSA = new JToggleButton(this.loadImageIcon("menuModeLSAImage"));
        this.toolButtonModeLSA.setName(menuModeStrings[2]);
        this.toolButtonModeLSA.addActionListener(this.actionListener);
        this.toolButtonModeLSA.setToolTipText(this.getResourceString(menuModeToolTipStrings[2]));
        bgMode.add(this.toolButtonModeLSA);
        this.toolBar.add(this.toolButtonModeLSA);
        this.toolButtonModeReflectance = new JToggleButton(this.loadImageIcon("menuModeReflectanceImage"));
        this.toolButtonModeReflectance.setName(menuModeStrings[3]);
        this.toolButtonModeReflectance.addActionListener(this.actionListener);
        this.toolButtonModeReflectance.setToolTipText(this.getResourceString(menuModeToolTipStrings[3]));
        bgMode.add(this.toolButtonModeReflectance);
        this.toolBar.add(this.toolButtonModeReflectance);
        this.toolButtonModeORL = new JToggleButton(this.loadImageIcon("menuModeORLImage"));
        this.toolButtonModeORL.setName(menuModeStrings[4]);
        this.toolButtonModeORL.addActionListener(this.actionListener);
        this.toolButtonModeORL.setToolTipText(this.getResourceString(menuModeToolTipStrings[4]));
        bgMode.add(this.toolButtonModeORL);
        this.toolBar.add(this.toolButtonModeORL);
        this.toolButtonModeRI = new JButton(this.loadImageIcon("menuModeRIImage"));
        this.toolButtonModeRI.setName("menuModeRI");
        this.toolButtonModeRI.addActionListener(this.actionListener);
        this.toolButtonModeRI.setToolTipText(this.getResourceString("menuModeRIToolTip"));
        this.toolBar.add(this.toolButtonModeRI);
        this.toolBar.addSeparator();
        this.toolButtonFixEvent = new JButton(this.loadImageIcon("menuEventsFixImage"));
        this.toolButtonFixEvent.setName(menuEventsStrings[1]);
        this.toolButtonFixEvent.addActionListener(this.actionListener);
        this.toolButtonFixEvent.setToolTipText(this.getResourceString(menuEventsToolTipStrings[1]));
        this.toolBar.add(this.toolButtonFixEvent);
        this.toolButtonDeleteEvent = new JButton(this.loadImageIcon("menuEventsDeleteImage"));
        this.toolButtonDeleteEvent.setName(menuEventsStrings[2]);
        this.toolButtonDeleteEvent.addActionListener(this.actionListener);
        this.toolButtonDeleteEvent.setToolTipText(this.getResourceString(menuEventsToolTipStrings[2]));
        this.toolBar.add(this.toolButtonDeleteEvent);
        this.toolButtonEventsTable = new JToggleButton(this.loadImageIcon("menuEventsTableImage"));
        this.toolButtonEventsTable.setName(menuEventsStrings[3]);
        this.toolButtonEventsTable.addActionListener(this.actionListener);
        this.toolButtonEventsTable.setToolTipText(this.getResourceString(menuEventsToolTipStrings[3]));
        this.toolBar.add(this.toolButtonEventsTable);
        this.toolButtonDoAuto = new JButton(this.loadImageIcon("menuEventsDoAutoImage"));
        this.toolButtonDoAuto.setName(menuEventsStrings[4]);
        this.toolButtonDoAuto.addActionListener(this.actionListener);
        this.toolButtonDoAuto.setToolTipText(this.getResourceString(menuEventsToolTipStrings[4]));
        this.toolBar.add(this.toolButtonDoAuto);
        this.toolButtonEventsParameters = new JButton(this.loadImageIcon("menuEventsParametersImage"));
        this.toolButtonEventsParameters.setName(menuEventsStrings[5]);
        this.toolButtonEventsParameters.addActionListener(this.actionListener);
        this.toolButtonEventsParameters.setToolTipText(this.getResourceString(menuEventsToolTipStrings[5]));
        this.toolBar.add(this.toolButtonEventsParameters);
        this.toolButtonEventsTwoWay = new JToggleButton(this.loadImageIcon("menuEventsTwoWayImage"));
        this.toolButtonEventsTwoWay.setName(menuEventsStrings[7]);
        this.toolButtonEventsTwoWay.addActionListener(this.actionListener);
        this.toolButtonEventsTwoWay.setToolTipText(this.getResourceString(menuEventsToolTipStrings[7]));
        this.toolBar.add(this.toolButtonEventsTwoWay);
        this.toolBar.addSeparator();
        this.toolBar.setFloatable(false);
        this.otdrWindow.add((Component)this.toolBar, "North");
    }

    void updateStatusBar() {
        int referenceSorFileIndex = this.getReferenceSorFileIndex();
        SorFile sorFile = this.getSorFile(referenceSorFileIndex);
        int i = 0;
        while (i < this.statusBar.getComponentCount()) {
            Component source = this.statusBar.getComponent(i);
            if (source != null && source instanceof JTextField) {
                String tmpS = "";
                JTextField tf = (JTextField)source;
                if (referenceSorFileIndex >= 0 && sorFile.isDataPtsPresent) {
                    switch (i) {
                        case 0: {
                            tmpS = 652 == sorFile.genParams.fiberType ? "SM-" : (653 == sorFile.genParams.fiberType ? "SM-" : (655 == sorFile.genParams.fiberType ? "SM-" : (651 == sorFile.genParams.fiberType ? "MM-" : "")));
                            tmpS = String.valueOf(tmpS) + Long.toString(sorFile.genParams.nominalWaveLength);
                            break;
                        }
                        case 1: {
                            tmpS = String.format("n = %.5f", Float.valueOf((float)sorFile.fxdParams.groupIndex / 100000.0f));
                            break;
                        }
                        case 2: {
                            float lMax = (long)sorFile.fxdParams.acquisitionRangeDistance != 0L ? (float)sorFile.fxdParams.acquisitionRangeDistance / 10.0f * sorFile.fxdParams.distanceMultiplier : (float)sorFile.recalcDistance(sorFile.getTimeIndex(sorFile.fxdParams.acquisitionRange));
                            tmpS = lMax > 5.0f ? String.format("Lmax = %.0f ", Float.valueOf(lMax)) : String.format("Lmax = %1.1f ", Float.valueOf(lMax));
                            tmpS = String.valueOf(tmpS) + this.getResourceString("km");
                            break;
                        }
                        case 3: {
                            short pulseWidth = sorFile.fxdParams.pulseWidthsUsed[0];
                            tmpS = String.format("Tp = %d ", pulseWidth);
                            tmpS = String.valueOf(tmpS) + this.getResourceString("ns");
                            break;
                        }
                        case 4: {
                            if (sorFile.fxdParams.averagingTime != 0) {
                                int seconds = sorFile.fxdParams.averagingTime / 10;
                                int hours = seconds / 3600;
                                int minutes = (seconds - hours * 3600) / 60;
                                seconds = seconds - hours * 3600 - minutes * 60;
                                tmpS = String.format("Tav = %02d:%02d:%02d", hours, minutes, seconds);
                                break;
                            }
                            tmpS = String.format("Nav = %d", sorFile.fxdParams.numberOfAverages);
                            break;
                        }
                        case 5: {
                            float l1 = (float)sorFile.recalcDistance(0);
                            tmpS = String.format("L1 = %.4f ", Float.valueOf(l1));
                            tmpS = String.valueOf(tmpS) + this.getResourceString("km");
                            break;
                        }
                        case 6: {
                            float l2 = (float)sorFile.recalcDistance(sorFile.dataPts.numberOfDataPoints);
                            tmpS = String.format("L2 = %.4f ", Float.valueOf(l2));
                            tmpS = String.valueOf(tmpS) + this.getResourceString("km");
                            break;
                        }
                        case 7: {
                            float dL = 1000.0f * (float)sorFile.recalcDistance(sorFile.positiveDistanceIndex, sorFile.positiveDistanceIndex + 1);
                            tmpS = dL < 1.0f ? String.format("dL = %.2f ", Float.valueOf(dL)) : String.format("dL = %.1f ", Float.valueOf(dL));
                            tmpS = String.valueOf(tmpS) + this.getResourceString("m");
                            break;
                        }
                        default: {
                            tmpS = this.getResourceString("error");
                        }
                    }
                }
                tf.setText(tmpS);
            }
            ++i;
        }
        this.statusBar.revalidate();
    }

    protected void createStatusbar() {
        this.statusBar = new StatusBar();
        int i = 0;
        while (statusBarItems[i] != null) {
            JTextField tf = new JTextField();
            tf.setHorizontalAlignment(0);
            tf.setFocusable(false);
            tf.setName(statusBarItems[i]);
            this.statusBar.add((Component)tf, i);
            ++i;
        }
        this.otdrWindow.add((Component)this.statusBar, "South");
        this.statusBar.revalidate();
    }

    public MainClass() {
        try {
            this.lookAndFeelInfos = UIManager.getInstalledLookAndFeels();
        }
        catch (Exception exc) {
            System.err.println("Error loading L&F: " + exc);
        }
        this.loadCurrentDirectory();
        this.sorFile = new SorFile[10];
        int i = 0;
        while (i < 10) {
            this.sorFile[i] = new SorFile();
            ++i;
        }
        this.scaleList = new String[9];
        this.maxXYScale = 1.0f;
        i = 0;
        while (i < this.scaleList.length) {
            this.scaleList[i] = String.format("%d", 1 << i);
            this.maxXYScale = (float)Math.max((double)this.maxXYScale, Double.valueOf(this.scaleList[i]));
            ++i;
        }
        this.actionListener = new MyActionListener(this);
        String[] extentions = new String[]{"sor"};
        this.sorFilter = this.createFileFilter("GR-196 CORE OTDR SOR files v 2.0", true, extentions);
        this.mainFrame = new JFrame();
        this.mainFrame.setMinimumSize(new Dimension(640, 480));
        this.mainFrame.setBounds(0, 0, 1025, 600);
        this.mainFrame.setIconImage(this.loadImageIcon("mainFrameIcon").getImage());
        this.mainFrame.setTitle(this.getResourceString("titleString"));
        this.otdrWindow = new OtdrWindow(this);
        this.mainFrame.add(this.otdrWindow);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainClass.this.quit();
            }
        });
        this.createToolBar();
        this.createStatusbar();
        this.imageFE = this.loadImageIcon("keyEventFiberEndImage");
        this.imageGain = this.loadImageIcon("keyEventGainImage");
        this.imageNR = this.loadImageIcon("keyEventNonReflectImage");
        this.imageR = this.loadImageIcon("keyEventReflectImage");
        this.otdrControlPanel = new OtdrControlPanel(this);
        this.otdrWindow.add((Component)this.otdrControlPanel, "West");
        this.createMenu();
        this.setMeasureMode(MeasureMode.MEASURE_MODE_2P_LOSS);
        this.enableRFGControls(false);
        this.analisysParametersDialog = new AnalisysParametersDialog((Frame)this.mainFrame, this);
        this.rfgInformationDialog = new RfgInformationDialog((Frame)this.mainFrame, this);
        this.aboutDialog = new AboutDialog((Frame)this.mainFrame, this);
        this.otdrWindow.validate();
        this.hlpFrame = new JFrame();
        this.hlpFrame.setIconImage(this.loadImageIcon("ShowHelpImage").getImage());
        this.hlpScroller = new JScrollPane();
        JViewport vp = this.hlpScroller.getViewport();
        this.html = new JEditorPane();
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this.createHyperLinkListener());
        vp.add(this.html);
        this.hlpFrame.add(this.hlpScroller);
        this.hlpFrame.setTitle(this.getResourceString("helpTitle"));
        this.hlpFrame.setBounds(this.mainFrame.getBounds());
        this.hlpFrame.setExtendedState(6);
    }

    public static void main(String[] args) {
        try {
            MainClass mainClass = new MainClass();
            mainClass.mainFrame.setVisible(true);
            if (args.length > 0) {
                mainClass.openSorFile(args[0], 0);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to start MainClass: " + e.getMessage());
        }
    }

    public void setMeasureMode(MeasureMode mm) {
        String tmpS1 = "";
        String tmpS2 = "";
        this.measureMode = mm;
        SorFile currSF = this.sorFile[this.currentSorFileIndex];
        if (this.menuItemFixEvent != null) {
            this.menuItemFixEvent.setEnabled(true);
        }
        if (this.toolButtonFixEvent != null) {
            this.toolButtonFixEvent.setEnabled(true);
        }
        currSF.cursor[2].setShown(false);
        currSF.cursor[3].setShown(false);
        currSF.cursor[4].setShown(false);
        switch (this.measureMode) {
            case MEASURE_MODE_2P_LOSS: {
                this.measureModeMenuItems[0].setSelected(true);
                this.toolButtonMode2P.setSelected(true);
                tmpS1 = this.getResourceString("dB");
                tmpS2 = this.getResourceString("dBPerKm");
                break;
            }
            case MEASURE_MODE_APPROX_LOSS: {
                this.measureModeMenuItems[1].setSelected(true);
                this.toolButtonModeLSALine.setSelected(true);
                currSF.lsaLine[0] = currSF.getLSALine(currSF.cursor[0].getDataIndex(), currSF.cursor[1].getDataIndex());
                tmpS1 = this.getResourceString("dB");
                tmpS2 = this.getResourceString("dBPerKm");
                break;
            }
            case MEASURE_MODE_LSA_LOSS: {
                this.measureModeMenuItems[2].setSelected(true);
                this.toolButtonModeLSA.setSelected(true);
                float x = currSF.getXStep() * (float)(currSF.cursor[0].getDataIndex() - currSF.indexOffset);
                currSF.cursor[2].setDataIndex(Math.round((x -= 50.0f * Float.valueOf(this.xScale).floatValue()) / currSF.getXStep()) + currSF.indexOffset);
                if (currSF.cursor[2].getDataIndex() >= currSF.cursor[0].getDataIndex()) {
                    currSF.cursor[2].setDataIndex(currSF.cursor[0].getDataIndex() - 1);
                }
                if (currSF.cursor[2].getDataIndex() < 0) {
                    currSF.cursor[2].setDataIndex(0);
                }
                x = currSF.getXStep() * (float)(currSF.cursor[1].getDataIndex() - currSF.indexOffset);
                currSF.cursor[3].setDataIndex(Math.round((x += 50.0f * Float.valueOf(this.xScale).floatValue()) / currSF.getXStep()) + currSF.indexOffset);
                if (currSF.cursor[3].getDataIndex() <= currSF.cursor[1].getDataIndex()) {
                    currSF.cursor[3].setDataIndex(currSF.cursor[1].getDataIndex() + 1);
                }
                if (currSF.cursor[3].getDataIndex() > currSF.dataPts.numberOfDataPoints - 1) {
                    currSF.cursor[3].setDataIndex(currSF.dataPts.numberOfDataPoints - 1);
                }
                currSF.cursor[4].setDataIndex((currSF.cursor[0].getDataIndex() + currSF.cursor[1].getDataIndex()) / 2);
                currSF.lsaLine[0] = currSF.getLSALine(currSF.cursor[2].getDataIndex(), currSF.cursor[0].getDataIndex());
                currSF.lsaLine[1] = currSF.getLSALine(currSF.cursor[3].getDataIndex(), currSF.cursor[1].getDataIndex());
                currSF.cursor[2].setShown(true);
                currSF.cursor[3].setShown(true);
                currSF.cursor[4].setShown(true);
                tmpS1 = "Spl, " + this.getResourceString("dB");
                tmpS2 = "Spl, " + this.getResourceString("km");
                break;
            }
            case MEASURE_MODE_REFLECTANCE: {
                this.measureModeMenuItems[3].setSelected(true);
                this.toolButtonModeReflectance.setSelected(true);
                tmpS1 = "Refl, " + this.getResourceString("dB");
                tmpS2 = "Refl, " + this.getResourceString("km");
                break;
            }
            case MEASURE_MODE_ORL: {
                this.measureModeMenuItems[4].setSelected(true);
                this.toolButtonModeORL.setSelected(true);
                if (this.menuItemFixEvent != null) {
                    this.menuItemFixEvent.setEnabled(false);
                }
                if (this.toolButtonFixEvent != null) {
                    this.toolButtonFixEvent.setEnabled(false);
                }
                tmpS1 = this.getResourceString("dB");
                tmpS2 = "ORL, " + this.getResourceString("dB");
                this.otdrControlPanel.setMiscParametersCaption(3, this.getResourceString("dB"));
                this.otdrControlPanel.setMiscParametersCaption(4, "ORL, " + this.getResourceString("dB"));
                break;
            }
            default: {
                tmpS1 = "error";
                tmpS2 = "error";
            }
        }
        this.otdrControlPanel.setMiscParametersCaption(3, " " + tmpS1);
        this.otdrControlPanel.setMiscParametersCaption(4, " " + tmpS2);
        this.updateOtdrControlPanel();
        this.otdrWindow.updateUI();
    }

    public MeasureMode getMeasureMode() {
        return this.measureMode;
    }

    public OTDRModuleParameters getOTDRModuleParameters() {
        return this.otdrModuleParameters;
    }

    public OTDRParametersDialog getOTDRParametersDialog() {
        return this.otdrParametersDialog;
    }

    public void setOTDRModuleParameters(OTDRModuleParameters to) {
        this.otdrModuleParameters = to;
    }

    public boolean canXZoomIn() {
        boolean ret = Float.valueOf(this.xScale).floatValue() < this.maxXYScale;
        return ret;
    }

    public boolean canXZoomOut() {
        boolean ret = Float.valueOf(this.xScale).floatValue() > 1.0f;
        return ret;
    }

    public boolean canYZoomIn() {
        boolean ret = Float.valueOf(this.yScale).floatValue() < this.maxXYScale;
        return ret;
    }

    public boolean canYZoomOut() {
        boolean ret = Float.valueOf(this.yScale).floatValue() > 1.0f;
        return ret;
    }

    public void setXScaleIndex(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index > this.scaleList.length - 1) {
            index = this.scaleList.length - 1;
        }
        this.xScale = this.scaleList[index];
    }

    public int getXScaleIndex() {
        float floatXScale = Float.valueOf(this.xScale).floatValue();
        int index = 0;
        while (index < this.scaleList.length) {
            float tmpXSclae = Float.valueOf(this.scaleList[index]).floatValue();
            if (floatXScale <= tmpXSclae) break;
            ++index;
        }
        return index;
    }

    public void setYScaleIndex(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index > this.scaleList.length - 1) {
            index = this.scaleList.length - 1;
        }
        this.yScale = this.scaleList[index];
    }

    public int getYScaleIndex() {
        float floatYScale = Float.valueOf(this.yScale).floatValue();
        int index = 0;
        while (index < this.scaleList.length) {
            float tmpYSclae = Float.valueOf(this.scaleList[index]).floatValue();
            if (floatYScale <= tmpYSclae) break;
            ++index;
        }
        return index;
    }

    public int getCurrentSorFileIndex() {
        return this.currentSorFileIndex;
    }

    public int getReferenceSorFileIndex() {
        int refI = -1;
        if (this.otdrControlPanel.isRfgChecked(this.currentSorFileIndex) && (this.sorFile[this.currentSorFileIndex].isDataPtsPresent || this.sorFile[this.currentSorFileIndex].isKeyEventsPresent)) {
            refI = this.currentSorFileIndex;
        } else {
            int i = 0;
            while (i < this.getSorFilesCount()) {
                if (this.otdrControlPanel.isRfgChecked(i) && (this.sorFile[i].isDataPtsPresent || this.sorFile[i].isKeyEventsPresent)) {
                    refI = i;
                    break;
                }
                ++i;
            }
        }
        return refI;
    }

    public void setCurrentSorFileIndex(int index) {
        if (index < 0 || index >= this.sorFile.length) {
            return;
        }
        if (this.currentSorFileIndex == index) {
            return;
        }
        this.currentSorFileIndex = index;
        this.updateAll();
    }

    public int getSorFilesCount() {
        int ret = this.sorFile == null ? 0 : this.sorFile.length;
        return ret;
    }

    public SorFile getSorFile(int index) {
        if (index < 0 || index > 9) {
            return null;
        }
        return this.sorFile[index];
    }

    public TL1RTUClient getTL1RTUClient() {
        return this.client;
    }

    public ImageIcon loadImageIcon(String resourceName) {
        ImageIcon icon = null;
        URL iconURL = this.getResource(resourceName);
        if (iconURL != null) {
            icon = new ImageIcon(iconURL);
        }
        return icon;
    }

    public void quit() {
        this.saveCurrentDirectory();
        if (this.client != null) {
            if (this.client.isConnected()) {
                this.client.disconnect();
                try {
                    this.client.join(5000L);
                }
                catch (Exception e) {
                    System.out.printf("Socket join error:\n", e.getMessage());
                }
            }
            this.client = null;
        }
        System.exit(0);
    }

    class FilePreviewer
    extends JComponent
    implements PropertyChangeListener {
        static final long serialVersionUID = 13L;
        private SorFile sorFile = null;
        private MainClass mainClass;

        public FilePreviewer(MainClass mClass, JFileChooser fc) {
            this.mainClass = mClass;
            this.setPreferredSize(new Dimension(200, 300));
            fc.addPropertyChangeListener(this);
        }

        public void loadSorFile(File f) {
            this.sorFile = null;
            if (f != null) {
                SorFile tmpSorFile = new SorFile();
                tmpSorFile.loadSorFileBuffer(f.getPath());
                tmpSorFile.filePath = f.getPath();
                if (tmpSorFile.extractSorFile()) {
                    this.sorFile = tmpSorFile;
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "SelectedFileChangedProperty" && this.isShowing()) {
                this.loadSorFile((File)e.getNewValue());
                this.repaint();
            }
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int width = this.getWidth();
            int height = this.getHeight() / 2;
            boolean isDataPresent = true;
            if (this.sorFile == null) {
                isDataPresent = false;
            } else if (this.sorFile.dataPts.scaledData == null) {
                isDataPresent = false;
            } else if (!this.sorFile.isDataPtsPresent) {
                isDataPresent = false;
            }
            g.setColor(RfgView.COLOR_BACK);
            g.fillRect(0, 0, width, height);
            if (isDataPresent) {
                float yStep = (float)(height - 1) / Math.abs(this.sorFile.dataPts.maxData - this.sorFile.dataPts.minData);
                float xStep = (float)width / (float)this.sorFile.dataPts.numberOfDataPoints;
                float old_x = 0.0f;
                float old_y = 0.0f;
                float x = xStep * 0.0f;
                float y = (this.sorFile.dataPts.scaledData[0] - this.sorFile.dataPts.minData) * yStep;
                g.setColor(RfgView.COLOR_RFG[0]);
                int i = 1;
                while (i < this.sorFile.dataPts.numberOfDataPoints) {
                    old_x = x;
                    old_y = y;
                    x = xStep * (float)i;
                    y = (this.sorFile.dataPts.scaledData[i] - this.sorFile.dataPts.minData) * yStep;
                    if (y >= (float)height) {
                        y = height - 1;
                    }
                    if (old_y >= (float)height) {
                        old_y = height - 1;
                    }
                    g.drawLine((int)old_x, (int)old_y, (int)x, (int)y);
                    ++i;
                }
                g.setColor(this.getForeground());
                FontMetrics fm = g.getFontMetrics();
                y = height;
                x = fm.stringWidth(" ");
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy     HH:mm:ss");
                Date date = new Date(this.sorFile.fxdParams.dateTimeStamp * 1000L);
                String tmpS = formatter.format(date);
                g.drawString(tmpS, (int)x, (int)(y += (float)fm.getHeight()));
                tmpS = this.sorFile.supParams.otdrMainFrameID;
                tmpS = String.valueOf(tmpS) + ", #";
                tmpS = String.valueOf(tmpS) + this.sorFile.supParams.otdrMainFrameSN;
                g.drawString(tmpS, (int)x, (int)(y += (float)fm.getHeight()));
                tmpS = this.sorFile.supParams.opticalModuleID;
                tmpS = String.valueOf(tmpS) + ", #";
                tmpS = String.valueOf(tmpS) + this.sorFile.supParams.opticalModuleSN;
                g.drawString(tmpS, (int)x, (int)(y += (float)fm.getHeight()));
                tmpS = String.format("%d ", this.sorFile.genParams.nominalWaveLength);
                tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("nm");
                g.drawString(tmpS, (int)x, (int)(y += (float)fm.getHeight()));
                tmpS = String.format("n = %f", Float.valueOf((float)this.sorFile.fxdParams.groupIndex / 100000.0f));
                g.drawString(tmpS, (int)x, (int)(y += (float)fm.getHeight()));
                float lMax = (long)this.sorFile.fxdParams.acquisitionRangeDistance != 0L ? (float)this.sorFile.fxdParams.acquisitionRangeDistance / 10.0f * this.sorFile.fxdParams.distanceMultiplier : (float)this.sorFile.recalcDistance(this.sorFile.getTimeIndex(this.sorFile.fxdParams.acquisitionRange));
                tmpS = lMax > 5.0f ? String.format("Lmax = %.0f ", Float.valueOf(lMax)) : String.format("Lmax = %.1f ", Float.valueOf(lMax));
                tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("km");
                g.drawString(tmpS, (int)x, (int)(y += (float)fm.getHeight()));
                i = 0;
                while (i < this.sorFile.fxdParams.totalNumberOfPulseWidthsUsed) {
                    tmpS = String.format("Tp[%d] = %d ", i, this.sorFile.fxdParams.pulseWidthsUsed[i]);
                    tmpS = String.valueOf(tmpS) + this.mainClass.getResourceString("ns");
                    g.drawString(tmpS, (int)x, (int)(y += (float)fm.getHeight()));
                    float dL = 1000.0f * (float)this.sorFile.recalcDistance(this.sorFile.positiveDistanceIndex, this.sorFile.positiveDistanceIndex + 1);
                    tmpS = dL < 1.0f ? String.format("dL[%d] = %.2f ", i, Float.valueOf(dL)) : String.format("dL[%d] = %.1f ", i, Float.valueOf(dL));
                    tmpS = String.valueOf(tmpS) + MainClass.this.getResourceString("m");
                    g.drawString(tmpS, (int)x, (int)(y += (float)fm.getHeight()));
                    ++i;
                }
                tmpS = String.format("Nav = %d", this.sorFile.fxdParams.numberOfAverages);
                g.drawString(tmpS, (int)x, (int)(y += (float)fm.getHeight()));
            }
        }
    }

    static enum InstrumentState {
        DISCONNECTED,
        CONNECTED,
        MEASURING,
        STOPPING_MEASURING,
        SETTING;

    }

    public static enum MeasureMode {
        MEASURE_MODE_NULL,
        MEASURE_MODE_2P_LOSS,
        MEASURE_MODE_APPROX_LOSS,
        MEASURE_MODE_LSA_LOSS,
        MEASURE_MODE_REFLECTANCE,
        MEASURE_MODE_ORL;

    }

    public class MyActionListener
    implements ActionListener {
        private MainClass mainClass;

        MyActionListener(MainClass mClass) {
            this.mainClass = mClass;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton button;
            Object source = e.getSource();
            String itemName = null;
            if (source instanceof JCheckBoxMenuItem) {
                JCheckBoxMenuItem cmi = (JCheckBoxMenuItem)source;
                itemName = cmi.getName();
                if (menuToolsStrings[1] == itemName) {
                    if (cmi.isSelected()) {
                        this.mainClass.otdrWindow.getRfgBackGroundPanel().getRfgView().autoSearchRfg();
                    }
                    return;
                }
                if (menuToolsStrings[2] == itemName) {
                    int i = 0;
                    while (i < 10) {
                        MainClass.this.sorFile[i].setCursorsFixed(cmi.isSelected());
                        ++i;
                    }
                    return;
                }
            } else if (source instanceof JRadioButtonMenuItem) {
                JRadioButtonMenuItem rmi = (JRadioButtonMenuItem)source;
                itemName = rmi.getName();
                if (itemName.contains("LookAndFeel")) {
                    int i = 0;
                    while (i < MainClass.this.lookAndFeelInfos.length) {
                        if (rmi.getText() != MainClass.this.lookAndFeelInfos[i].getName()) {
                            MainClass.this.lafMenuItems[i].setSelected(false);
                        } else {
                            MainClass.this.lafMenuItems[i].setSelected(true);
                            try {
                                UIManager.setLookAndFeel(MainClass.this.lookAndFeelInfos[i].getClassName());
                                SwingUtilities.updateComponentTreeUI(this.mainClass.mainFrame);
                                SwingUtilities.updateComponentTreeUI(this.mainClass.analisysParametersDialog);
                                SwingUtilities.updateComponentTreeUI(this.mainClass.rfgInformationDialog);
                            }
                            catch (Exception exc) {
                                System.err.println("Error loading L&F: " + exc);
                            }
                        }
                        ++i;
                    }
                    return;
                }
            } else if (source instanceof JMenuItem) {
                JMenuItem mi = (JMenuItem)source;
                itemName = mi.getName();
            } else if (source instanceof JButton) {
                button = (JButton)source;
                itemName = button.getName();
            } else if (source instanceof JToggleButton) {
                button = (JToggleButton)source;
                itemName = button.getName();
            }
            if (itemName != null) {
                RfgView rfgView = MainClass.this.otdrWindow.getRfgBackGroundPanel().getRfgView();
                if (itemName != "menuZoomMode") {
                    if (itemName == "menuZoomOff") {
                        rfgView.zoomX(0);
                        rfgView.zoomY(0);
                    } else if (itemName == "menuZoomInX") {
                        rfgView.zoomX(MainClass.this.getXScaleIndex() + 1);
                    } else if (itemName == "menuZoomOutX") {
                        rfgView.zoomX(MainClass.this.getXScaleIndex() - 1);
                    } else if (itemName == "menuZoomInY") {
                        rfgView.zoomY(MainClass.this.getYScaleIndex() + 1);
                    } else if (itemName == "menuZoomOutY") {
                        rfgView.zoomY(MainClass.this.getYScaleIndex() - 1);
                    } else if (itemName == menuFileStrings[1]) {
                        this.mainClass.openSorFile();
                    } else if (itemName == menuFileStrings[3]) {
                        MainClass.this.closeAllSorFiles();
                    } else if (itemName == menuFileStrings[2]) {
                        this.mainClass.closeSorFile(MainClass.this.currentSorFileIndex);
                    } else if (itemName == menuFileStrings[5]) {
                        this.mainClass.saveSorFile(MainClass.this.currentSorFileIndex);
                    } else if (itemName == menuFileStrings[6]) {
                        this.mainClass.saveSorFileAS(MainClass.this.currentSorFileIndex);
                    } else if (itemName == menuFileStrings[11]) {
                        MainClass.this.rfgInformationDialog.setVisible(true);
                    } else if (itemName.compareTo(menuFileStrings[12]) == 0) {
                        TemplateParametersDialog tpd = new TemplateParametersDialog((Frame)MainClass.this.mainFrame, this.mainClass);
                        tpd.setVisible(true);
                    } else if (itemName == menuFileStrings[8]) {
                        this.mainClass.pageFormat();
                    } else if (itemName == menuFileStrings[9]) {
                        MainClass.this.print();
                    } else if (itemName == menuFileStrings[14]) {
                        MainClass.this.quit();
                    } else if (itemName == menuMeasuringStrings[1]) {
                        if (MainClass.this.client == null || !MainClass.this.client.isConnected()) {
                            MainClass.this.otdrModuleParameters = new OTDRModuleParameters();
                            MainClass.this.client = new TL1RTUClient(this.mainClass);
                            OTDRFindDialog otdrFindDialog = new OTDRFindDialog(this.mainClass);
                            MainClass.this.client.setOTDRFindDialog(otdrFindDialog);
                            OTDRSocket socket = new OTDRSocket(this.mainClass);
                            if (socket.inputConnectionParametersResult) {
                                MainClass.this.client.setIO(socket);
                                MainClass.this.client.connect();
                                otdrFindDialog.setVisible(true);
                            }
                        }
                    } else if (itemName == menuMeasuringStrings[2]) {
                        if (MainClass.this.client != null && MainClass.this.client.isConnected()) {
                            MainClass.this.client.disconnect();
                            MainClass.this.client = null;
                        }
                    } else if (itemName == menuMeasuringStrings[4]) {
                        if (MainClass.this.client != null && MainClass.this.client.isConnected()) {
                            OTDRProgressDialog otdrProgressDialog = new OTDRProgressDialog(this.mainClass);
                            MainClass.this.client.setOTDRProgressDialog(otdrProgressDialog);
                            otdrProgressDialog.setMinimum(0);
                            otdrProgressDialog.setProgress(0);
                            MainClass.this.client.startMeas(true);
                            otdrProgressDialog.setVisible(true);
                        }
                    } else if (itemName == menuMeasuringStrings[5]) {
                        if (MainClass.this.client != null && MainClass.this.client.isConnected()) {
                            MainClass.this.client.startMeas(false);
                        }
                    } else if (itemName == menuMeasuringStrings[6]) {
                        if (MainClass.this.client != null && MainClass.this.client.isConnected()) {
                            MainClass.this.client.stopMeas();
                        }
                    } else if (itemName == menuMeasuringStrings[8]) {
                        if (MainClass.this.client != null && MainClass.this.client.isConnected()) {
                            if (MainClass.this.otdrParametersDialog == null) {
                                MainClass.this.otdrParametersDialog = new OTDRParametersDialog(this.mainClass);
                            }
                            MainClass.this.otdrParametersDialog.setVisible(true);
                            MainClass.this.otdrParametersDialog.updateView();
                        }
                    } else if (itemName == "menuMode2P") {
                        MainClass.this.setMeasureMode(MeasureMode.MEASURE_MODE_2P_LOSS);
                    } else if (itemName == "menuModeLSALine") {
                        MainClass.this.setMeasureMode(MeasureMode.MEASURE_MODE_APPROX_LOSS);
                    } else if (itemName == "menuModeLSA") {
                        MainClass.this.setMeasureMode(MeasureMode.MEASURE_MODE_LSA_LOSS);
                    } else if (itemName == "menuModeReflectance") {
                        MainClass.this.setMeasureMode(MeasureMode.MEASURE_MODE_REFLECTANCE);
                    } else if (itemName == "menuModeORL") {
                        MainClass.this.setMeasureMode(MeasureMode.MEASURE_MODE_ORL);
                    } else if (itemName == "menuModeRI") {
                        RefractiveIndexDialog dlgRI = new RefractiveIndexDialog((Frame)MainClass.this.mainFrame, this.mainClass);
                        dlgRI.setVisible(true);
                    } else if (menuEventsStrings[1] == itemName) {
                        SorFile sorFile = this.mainClass.getSorFile(MainClass.this.currentSorFileIndex);
                        sorFile.fixEvent(MainClass.this.measureMode, (short)-1);
                        if (MainClass.this.isTwoWayChecked()) {
                            MainClass.this.menuEventsTwoWayChanged();
                        } else {
                            rfgView.invalidateView();
                            rfgView.updateUI();
                            MainClass.this.otdrWindow.otdrEventsPanel.updateView();
                        }
                    } else if (menuEventsStrings[2] == itemName) {
                        SorFile sorFile = this.mainClass.getSorFile(MainClass.this.currentSorFileIndex);
                        sorFile.deleteEventsBetweenCursors(sorFile.cursor[0].getDataIndex(), sorFile.cursor[1].getDataIndex());
                        if (MainClass.this.isTwoWayChecked()) {
                            MainClass.this.menuEventsTwoWayChanged();
                        } else {
                            rfgView.invalidateView();
                            rfgView.updateUI();
                            MainClass.this.otdrWindow.otdrEventsPanel.updateView();
                        }
                    } else if (menuEventsStrings[3] == itemName) {
                        MainClass.this.otdrWindow.otdrEventsPanel.setVisible(!MainClass.this.otdrWindow.otdrEventsPanel.isVisible());
                        MainClass.this.toolButtonEventsTable.setSelected(MainClass.this.otdrWindow.otdrEventsPanel.isVisible());
                        MainClass.this.menuItemEventsTable.setSelected(MainClass.this.otdrWindow.otdrEventsPanel.isVisible());
                        MainClass.this.otdrWindow.otdrEventsPanel.validate();
                        MainClass.this.otdrWindow.validate();
                        MainClass.this.otdrWindow.updateUI();
                        if (!MainClass.this.otdrWindow.otdrEventsPanel.isVisible()) {
                            MainClass.this.otdrWindow.otdrEventsPanel.resetButtonMove();
                        }
                    } else if (menuEventsStrings[5] == itemName) {
                        MainClass.this.analisysParametersDialog.setVisible(true);
                    } else if (menuEventsStrings[4] == itemName) {
                        SorFile sorFile = this.mainClass.getSorFile(MainClass.this.currentSorFileIndex);
                        MainClass.this.mainFrame.setCursor(new Cursor(3));
                        sorFile.doAuto(this.mainClass);
                        MainClass.this.mainFrame.setCursor(new Cursor(0));
                        if (MainClass.this.isTwoWayChecked()) {
                            MainClass.this.menuEventsTwoWayChanged();
                        } else {
                            rfgView.invalidateView();
                            rfgView.updateUI();
                            MainClass.this.otdrWindow.otdrEventsPanel.updateView();
                        }
                    } else if (menuEventsStrings[7] == itemName) {
                        boolean on = false;
                        if (source == MainClass.this.toolButtonEventsTwoWay) {
                            on = MainClass.this.toolButtonEventsTwoWay.isSelected();
                        }
                        if (source == MainClass.this.menuItemEventsTwoWay) {
                            on = MainClass.this.menuItemEventsTwoWay.isSelected();
                        }
                        MainClass.this.toolButtonEventsTwoWay.setSelected(on);
                        MainClass.this.menuItemEventsTwoWay.setSelected(on);
                        MainClass.this.menuEventsTwoWayChanged();
                    } else if (menuHelpStrings[1] == itemName) {
                        URL url = null;
                        String path = this.mainClass.getResourceString("HelpIndexPath");
                        url = this.getClass().getResource(path);
                        if (url != null) {
                            try {
                                MainClass.this.html.setPage(url);
                            }
                            catch (IOException ioe) {
                                System.out.println("IOException!!!");
                            }
                        } else {
                            System.out.println("url = null");
                        }
                        if (MainClass.this.html != null) {
                            MainClass.QDEBUG("html != null\n", new Object[0]);
                            MainClass.this.hlpFrame.setVisible(true);
                        }
                    } else if (menuHelpStrings[2] == itemName) {
                        MainClass.this.aboutDialog.setVisible(true);
                    } else {
                        System.out.println("Unknown action performed!!!");
                        System.out.println(itemName);
                    }
                }
            }
        }
    }

    class StatusBar
    extends JComponent {
        static final long serialVersionUID = 5L;

        public StatusBar() {
            this.setLayout(new BoxLayout(this, 0));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }
    }
}

