/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        11.01.2009
 Description:    Ansteuerung des MAX7456

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
----------------------------------------------------------------------------*/

#ifndef _PAL_H
 #define _PAL_H

	#include <avr/interrupt.h>
	#include <avr/pgmspace.h>
	#include <stdlib.h>
	#include <stdarg.h>
	#include <ctype.h>
	#include <string.h>
	#include <avr/io.h>
    
    #define F_CPU 12000000
    
    #define PAL_CS_HIGH PORTB |= (1<<PB1);
    #define PAL_CS_LOW  PORTB &= ~(1<<PB1);

    volatile unsigned int display_memory_address;

    extern void pal_init (void);
    void pal_clear (void);
    void pal_write_str(char *);
    void pal_write_char(char);
	
    void pal_write_P (const char *Buffer,...);
    #define pal_write(format, args...)   pal_write_P(PSTR(format) , ## args)


    /**************************************************************************************
     * spiWriteRegAutoIncr
     *
     * Writes to an 8-bit register with the SPI port by using the MAX7456's autoincrement mode
     **************************************************************************************/
                                                                    // MAX7456 VIDEO_MODE_0 register
    #define VIDEO_MODE_0_WRITE              0x00
    #define VIDEO_MODE_0_READ               0x80
    #define VIDEO_MODE_0_40_PAL             0x40
    #define VIDEO_MODE_0_20_NoAutoSync      0x20
    #define VIDEO_MODE_0_10_SyncInt         0x10
    #define VIDEO_MODE_0_08_EnOSD           0x08
    #define VIDEO_MODE_0_04_UpdateVsync     0x04
    #define VIDEO_MODE_0_02_Reset           0x02
    #define VIDEO_MODE_0_01_EnVideo         0x01
                                                                    // VIDEO MODE 0 bitmap
    #define NTSC                            0x00
    #define PAL                             0x40
    #define AUTO_SYNC                       0x00
    #define EXT_SYNC                        0x20
    #define INT_SYNC                        0x30
    #define OSD_EN                          0x08
    #define VERT_SYNC_IMM                   0x00
    #define VERT_SYNC_VSYNC                 0x04
    #define SW_RESET                        0x02
    #define BUF_EN                          0x00
    #define BUF_DI                          0x01

                                                                    // MAX7456 VIDEO_MODE_1 register
    #define VIDEO_MODE_1_WRITE              0x01
    #define VIDEO_MODE_1_READ               0x81

                                                                    // MAX7456 DM_MODE register
    #define DM_MODE_WRITE                   0x04
    #define DM_MODE_READ                    0x84

                                                                    // MAX7456 DM_ADDRH register
    #define DM_ADDRH_WRITE                  0x05
    #define DM_ADDRH_READ                   0x85

                                                                    // MAX7456 DM_ADDRL register
    #define DM_ADDRL_WRITE                  0x06
    #define DM_ADDRL_READ                   0x87

                                                                    // MAX7456 DM_CODE_IN register
    #define DM_CODE_IN_WRITE                0x07
    #define DM_CODE_IN_READ                 0x87

                                                                    // MAX7456 DM_CODE_OUT register
    #define DM_CODE_OUT_READ                0xB0

                                                                    // MAX7456 FM_MODE register
    #define FM_MODE_WRITE                   0x08
    #define FM_MODE_READ                    0x88

                                                                    // MAX7456 FM_ADDRH register
    #define FM_ADDRH_WRITE                  0x09
    #define FM_ADDRH_READ                   0x89

                                                                    // MAX7456 FM_ADDRL register
    #define FM_ADDRL_WRITE                  0x0A
    #define FM_ADDRL_READ                   0x8A

                                                                    // MAX7456 FM_DATA_IN register
    #define FM_DATA_IN_WRITE                0x0B
    #define FM_DATA_IN_READ                 0x8B

                                                                    // MAX7456 FM_DATA_OUT register
    #define FM_DATA_OUT_READ                0xC0

                                                                    // MAX7456 STATUS register
    #define STATUS_READ                     0xA0
    #define STATUS_40_RESET_BUSY            0x40
    #define STATUS_20_NVRAM_BUSY            0x20
    #define STATUS_04_LOSS_OF_SYNC          0x04
    #define STATUS_02_PAL_DETECTED          0x02
    #define STATUS_01_NTSC_DETECTED         0x01

                                                                    // MAX7456 requires clearing OSD Black Level
                                                                    // register bit 0x10 after reset
    #define OSDBL_WR                        0x6C
    #define OSDBL_RD                        0xEC
    #define OSDBL_10_DisableAutoBlackLevel  0x10



#endif
